"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
/**
 * A Step Functions Task to to set Termination Protection on an EMR Cluster.
 *
 * @experimental
 */
class EmrSetClusterTerminationProtection {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'setClusterTerminationProtection', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: ['elasticmapreduce:SetTerminationProtection'],
                    resources: [`arn:aws:elasticmapreduce:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:cluster/*`],
                }),
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                TerminationProtected: this.props.terminationProtected,
            },
        };
    }
}
exports.EmrSetClusterTerminationProtection = EmrSetClusterTerminationProtection;
//# sourceMappingURL=data:application/json;base64,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