#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.tech_filter_input import TechFilterInput
from ..input.tech_order import TechOrder


# fmt: off
QUERY: List[str] = ["""
query techs(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: TechOrder
$filterBy: [TechFilterInput!]
){
techs(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
id
name

}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class techs:
    @dataclass(frozen=True)
    class techsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class TechConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class TechEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Tech(DataClassJsonMixin):
                    id: str
                    name: str

                node: Optional[Tech]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[TechEdge]
            pageInfo: PageInfo

        techs: TechConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[TechOrder] = None, filterBy: List[TechFilterInput] = []) -> techsData.TechConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.techsData.from_dict(response_text)
        return res.techs

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[TechOrder] = None, filterBy: List[TechFilterInput] = []) -> techsData.TechConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.techsData.from_dict(response_text)
        return res.techs
