#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.service_type import ServiceTypeFragment, QUERY as ServiceTypeFragmentQuery


# fmt: off
QUERY: List[str] = ServiceTypeFragmentQuery + ["""
query ServiceTypesQuery {
  serviceTypes {
    edges {
      node {
        ...ServiceTypeFragment
      }
    }
  }
}

"""
]


class ServiceTypesQuery:
    @dataclass(frozen=True)
    class ServiceTypesQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ServiceTypeConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ServiceTypeEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ServiceType(ServiceTypeFragment):
                    pass

                node: Optional[ServiceType]

            edges: List[ServiceTypeEdge]

        serviceTypes: Optional[ServiceTypeConnection]

    # fmt: off
    @classmethod
    def execute(cls, client: Client) -> Optional[ServiceTypesQueryData.ServiceTypeConnection]:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ServiceTypesQueryData.from_dict(response_text)
        return res.serviceTypes

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client) -> Optional[ServiceTypesQueryData.ServiceTypeConnection]:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ServiceTypesQueryData.from_dict(response_text)
        return res.serviceTypes
