#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.recommendations_sources_filter_input import RecommendationsSourcesFilterInput
from ..input.recommendations_sources_order import RecommendationsSourcesOrder


# fmt: off
QUERY: List[str] = ["""
query RecommendationsSources(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: RecommendationsSourcesOrder
$filterBy: [RecommendationsSourcesFilterInput!]
){
RecommendationsSources(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
id
name

}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}


"""
]


class RecommendationsSources:
    @dataclass(frozen=True)
    class RecommendationsSourcesData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class RecommendationsSourcesConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class RecommendationsSourcesEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class RecommendationsSources(DataClassJsonMixin):
                    id: str
                    name: str

                node: Optional[RecommendationsSources]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[RecommendationsSourcesEdge]
            pageInfo: PageInfo

        RecommendationsSources: RecommendationsSourcesConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[RecommendationsSourcesOrder] = None, filterBy: List[RecommendationsSourcesFilterInput] = []) -> RecommendationsSourcesData.RecommendationsSourcesConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.RecommendationsSourcesData.from_dict(response_text)
        return res.RecommendationsSources

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[RecommendationsSourcesOrder] = None, filterBy: List[RecommendationsSourcesFilterInput] = []) -> RecommendationsSourcesData.RecommendationsSourcesConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.RecommendationsSourcesData.from_dict(response_text)
        return res.RecommendationsSources
