#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.edit_recommendations_input import EditRecommendationsInput


# fmt: off
QUERY: List[str] = ["""
mutation editRecommendations($input: EditRecommendationsInput!) {
  editRecommendations(input: $input) {
		id
    externalID
    resource
    alarmType
    shortDescription
    longDescription
    command
    priority
    status
    runbook
    used
    recommendationsSources{id}
    recommendationsCategory{id}
    userApprobed{id}
    vendor{id}
    
  }
}
"""
]


class editRecommendations:
    @dataclass(frozen=True)
    class editRecommendationsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Recommendations(DataClassJsonMixin):
            @dataclass(frozen=True)
            class RecommendationsSources(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class RecommendationsCategory(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class User(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class Vendor(DataClassJsonMixin):
                id: str

            id: str
            externalID: str
            resource: str
            alarmType: str
            shortDescription: str
            longDescription: str
            command: Optional[str]
            priority: int
            status: bool
            runbook: Optional[str]
            used: Optional[int]
            recommendationsSources: RecommendationsSources
            recommendationsCategory: RecommendationsCategory
            userApprobed: Optional[User]
            vendor: Vendor

        editRecommendations: Recommendations

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditRecommendationsInput) -> editRecommendationsData.Recommendations:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editRecommendationsData.from_dict(response_text)
        return res.editRecommendations

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditRecommendationsInput) -> editRecommendationsData.Recommendations:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editRecommendationsData.from_dict(response_text)
        return res.editRecommendations
