#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.location import LocationFragment, QUERY as LocationFragmentQuery

from ..input.edit_location_input import EditLocationInput


# fmt: off
QUERY: List[str] = LocationFragmentQuery + ["""
mutation EditLocationMutation($input: EditLocationInput!) {
  editLocation(input: $input) {
    ...LocationFragment
  }
}

"""
]


class EditLocationMutation:
    @dataclass(frozen=True)
    class EditLocationMutationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Location(LocationFragment):
            pass

        editLocation: Location

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditLocationInput) -> EditLocationMutationData.Location:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EditLocationMutationData.from_dict(response_text)
        return res.editLocation

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditLocationInput) -> EditLocationMutationData.Location:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EditLocationMutationData.from_dict(response_text)
        return res.editLocation
