#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.service import ServiceFragment, QUERY as ServiceFragmentQuery

from ..input.service_create_data import ServiceCreateData


# fmt: off
QUERY: List[str] = ServiceFragmentQuery + ["""
mutation AddServiceMutation($data: ServiceCreateData!) {
  addService(data: $data) {
    ...ServiceFragment
  }
}

"""
]


class AddServiceMutation:
    @dataclass(frozen=True)
    class AddServiceMutationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Service(ServiceFragment):
            pass

        addService: Service

    # fmt: off
    @classmethod
    def execute(cls, client: Client, data: ServiceCreateData) -> AddServiceMutationData.Service:
        variables: Dict[str, Any] = {"data": data}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.AddServiceMutationData.from_dict(response_text)
        return res.addService

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, data: ServiceCreateData) -> AddServiceMutationData.Service:
        variables: Dict[str, Any] = {"data": data}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.AddServiceMutationData.from_dict(response_text)
        return res.addService
