# Generated by Django 3.1.8 on 2021-05-25 21:29

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Invoice',
            fields=[
                ('id', models.BigAutoField(editable=False, primary_key=True, serialize=False)),
                ('gid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.UUIDField()),
                ('type', models.CharField(blank=True, choices=[('i', 'invoice'), ('e', 'estimate'), ('cn', 'credit note')], max_length=2, null=True)),
                ('number', models.IntegerField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=63, null=True)),
                ('address1', models.CharField(blank=True, max_length=63, null=True)),
                ('address2', models.CharField(blank=True, max_length=63, null=True)),
                ('zip_code', models.CharField(blank=True, max_length=63, null=True)),
                ('city', models.CharField(blank=True, max_length=63, null=True)),
                ('country', models.CharField(blank=True, max_length=63, null=True)),
                ('state', models.CharField(blank=True, max_length=63, null=True)),
                ('company', models.CharField(blank=True, max_length=63, null=True)),
                ('vat', models.CharField(blank=True, max_length=63, null=True)),
                ('payment_reference', models.CharField(blank=True, max_length=63, null=True)),
                ('payment_provider', models.CharField(blank=True, max_length=63, null=True)),
                ('is_paid', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InvoiceDetail',
            fields=[
                ('id', models.BigAutoField(editable=False, primary_key=True, serialize=False)),
                ('gid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=63)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=8)),
                ('invoice', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='details', to='tuhls_invoice.invoice')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
