"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const common_1 = require("../utils/common");
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.pbSubnets = [];
        this.pvSubnets = [];
        this.natSubnets = [];
        this.peeringConnectionIds = {};
        this.vpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, 'VPC', props.vpc);
        if (props.peeringConfigs) {
            const convertPeeringConfig = common_1.ObjToStrMap(props.peeringConfigs);
            convertPeeringConfig.forEach((createVpcPeering, key) => {
                let peeringConnectionIdByKey = new aws_cdk_lib_1.aws_ec2.CfnVPCPeeringConnection(this, `PeerDestination-${key}`, {
                    vpcId: this.vpc.vpcId,
                    peerVpcId: createVpcPeering.peeringVpcId,
                    peerOwnerId: createVpcPeering.peerOwnerId,
                    peerRoleArn: createVpcPeering.peerAssumeRoleArn,
                    peerRegion: createVpcPeering.peerRegion,
                });
                const tags = common_1.ObjToStrMap(createVpcPeering.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(peeringConnectionIdByKey).add(k, v);
                });
                console.log(`test value ${peeringConnectionIdByKey}`);
                this.peeringConnectionIds[key] = peeringConnectionIdByKey;
            });
        }
        props.subnets.forEach((subnetProps) => {
            let subnet = this.createSubnet(subnetProps, this.vpc, this.peeringConnectionIds);
            subnet.forEach((sb) => {
                if (sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.pbSubnets.push(sb);
                }
                else if (sb instanceof aws_cdk_lib_1.aws_ec2.PrivateSubnet) {
                    this.pvSubnets.push(sb);
                }
                if (subnetProps.subnetGroupName == 'NATGateway' &&
                    sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.natSubnets.push(sb);
                }
            });
        });
        const internetGateway = new aws_cdk_lib_1.aws_ec2.CfnInternetGateway(this, 'InternetGateway', {});
        const att = new aws_cdk_lib_1.aws_ec2.CfnVPCGatewayAttachment(this, 'VPCGatewayAttachement', {
            internetGatewayId: internetGateway.ref,
            vpcId: this.vpc.vpcId,
        });
        this.pbSubnets.forEach((pb) => {
            pb.addDefaultInternetRoute(internetGateway.ref, att);
        });
        if (this.natSubnets.length > 0) {
            this.natProvider = aws_cdk_lib_1.aws_ec2.NatProvider.gateway();
            this.natProvider.configureNat({
                vpc: this.vpc,
                natSubnets: this.natSubnets,
                privateSubnets: this.pvSubnets,
            });
        }
    }
    createSubnet(option, vpc, peeringConnectionId) {
        var _b, _c;
        const subnets = [];
        const SUBNETTYPE_TAG = 'aws-cdk:subnet-type';
        const SUBNETNAME_TAG = 'aws-cdk:subnet-name';
        const NAME_TAG = 'Name';
        if (option.availabilityZones.length != option.cidrBlock.length) {
            // eslint-disable-next-line max-len
            throw new Error("You cannot reference a Subnet's availability zone if it was not supplied. Add the availabilityZone when importing using option.fromSubnetAttributes()");
        }
        option.availabilityZones.forEach((az, index) => {
            var _b;
            let subnet = option.subnetType === aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC
                ? new aws_cdk_lib_1.aws_ec2.PublicSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: true,
                })
                : new aws_cdk_lib_1.aws_ec2.PrivateSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: false,
                });
            (_b = option.routes) === null || _b === void 0 ? void 0 : _b.forEach((route, routeIndex) => {
                var _b;
                if (peeringConnectionId != undefined && route.existingVpcPeeringRouteKey != undefined) {
                    console.log(`peeringConnectionid ${peeringConnectionId}`);
                    console.log(`existingVpcPeeringRouteKey ${route.existingVpcPeeringRouteKey}`);
                    console.log(`object ${Object.keys(peeringConnectionId)}`);
                    console.log(`object get value ${peeringConnectionId[route.existingVpcPeeringRouteKey]}`);
                    let routeId = peeringConnectionId[route.existingVpcPeeringRouteKey];
                    console.log(routeId);
                    if (routeId != undefined) {
                        subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                            routerId: routeId.ref,
                            routerType: route.routerType,
                            destinationCidrBlock: route.destinationCidrBlock,
                        });
                    }
                }
                else if (route.routerId != undefined) {
                    subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                        routerId: (_b = route.routerId) !== null && _b !== void 0 ? _b : '',
                        routerType: route.routerType,
                        destinationCidrBlock: route.destinationCidrBlock,
                    });
                }
            });
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETNAME_TAG, option.subnetGroupName);
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETTYPE_TAG, option.subnetType);
            if (option.tags != undefined) {
                const tags = common_1.ObjToStrMap(option.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(subnet).add(k, v);
                });
            }
            subnets.push(subnet);
        });
        const nacl = new aws_cdk_lib_1.aws_ec2.NetworkAcl(this, `${option.subnetGroupName}NACL`, {
            vpc: vpc,
            subnetSelection: {
                subnets: subnets,
            },
        });
        aws_cdk_lib_1.Tags.of(nacl).add(NAME_TAG, nacl.node.path);
        (_b = option.ingressNetworkACL) === null || _b === void 0 ? void 0 : _b.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}IngressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.INGRESS,
            });
        });
        (_c = option.egressNetworkACL) === null || _c === void 0 ? void 0 : _c.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}EgressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.EGRESS,
            });
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutSubnets`, {
            value: subnets
                .map((subnet) => {
                return subnet.subnetId;
            })
                .join(','),
            description: `${option.subnetGroupName} subnets cross`,
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutNACL`, {
            value: nacl.networkAclId,
            description: `${option.subnetGroupName} subnets associated this nacl`,
        });
        return subnets;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@smallcase/cdk-vpc-module.Network", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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