# Copyright 2018 eShares, Inc. dba Carta, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed
# under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
# CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
# language governing permissions and limitations under the License.

#
# Autogenerated by Thrift Compiler (0.11.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
from thrift.TRecursive import fix_spec

import sys
import logging
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
all_structs = []


class Iface(object):
    def Create(self, feature_name, is_enabled, client_data):
        """
        Parameters:
         - feature_name
         - is_enabled
         - client_data
        """
        pass

    def Get(self, feature_name):
        """
        Parameters:
         - feature_name
        """
        pass

    def Set(self, feature_name, is_enabled):
        """
        Parameters:
         - feature_name
         - is_enabled
        """
        pass

    def Delete(self, feature_name):
        """
        Parameters:
         - feature_name
        """
        pass

    def List(self, limit, offset):
        """
        Parameters:
         - limit
         - offset
        """
        pass

    def SetMeta(self, feature_name, meta):
        """
        Parameters:
         - feature_name
         - meta
        """
        pass


class Client(Iface):
    def __init__(self, iprot, oprot=None):
        self._iprot = self._oprot = iprot
        if oprot is not None:
            self._oprot = oprot
        self._seqid = 0

    def Create(self, feature_name, is_enabled, client_data):
        """
        Parameters:
         - feature_name
         - is_enabled
         - client_data
        """
        self.send_Create(feature_name, is_enabled, client_data)
        return self.recv_Create()

    def send_Create(self, feature_name, is_enabled, client_data):
        self._oprot.writeMessageBegin('Create', TMessageType.CALL, self._seqid)
        args = Create_args()
        args.feature_name = feature_name
        args.is_enabled = is_enabled
        args.client_data = client_data
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_Create(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = Create_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.error is not None:
            raise result.error
        raise TApplicationException(TApplicationException.MISSING_RESULT, "Create failed: unknown result")

    def Get(self, feature_name):
        """
        Parameters:
         - feature_name
        """
        self.send_Get(feature_name)
        return self.recv_Get()

    def send_Get(self, feature_name):
        self._oprot.writeMessageBegin('Get', TMessageType.CALL, self._seqid)
        args = Get_args()
        args.feature_name = feature_name
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_Get(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = Get_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.error is not None:
            raise result.error
        raise TApplicationException(TApplicationException.MISSING_RESULT, "Get failed: unknown result")

    def Set(self, feature_name, is_enabled):
        """
        Parameters:
         - feature_name
         - is_enabled
        """
        self.send_Set(feature_name, is_enabled)
        self.recv_Set()

    def send_Set(self, feature_name, is_enabled):
        self._oprot.writeMessageBegin('Set', TMessageType.CALL, self._seqid)
        args = Set_args()
        args.feature_name = feature_name
        args.is_enabled = is_enabled
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_Set(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = Set_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.error is not None:
            raise result.error
        return

    def Delete(self, feature_name):
        """
        Parameters:
         - feature_name
        """
        self.send_Delete(feature_name)
        self.recv_Delete()

    def send_Delete(self, feature_name):
        self._oprot.writeMessageBegin('Delete', TMessageType.CALL, self._seqid)
        args = Delete_args()
        args.feature_name = feature_name
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_Delete(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = Delete_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.error is not None:
            raise result.error
        return

    def List(self, limit, offset):
        """
        Parameters:
         - limit
         - offset
        """
        self.send_List(limit, offset)
        return self.recv_List()

    def send_List(self, limit, offset):
        self._oprot.writeMessageBegin('List', TMessageType.CALL, self._seqid)
        args = List_args()
        args.limit = limit
        args.offset = offset
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_List(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = List_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.error is not None:
            raise result.error
        raise TApplicationException(TApplicationException.MISSING_RESULT, "List failed: unknown result")

    def SetMeta(self, feature_name, meta):
        """
        Parameters:
         - feature_name
         - meta
        """
        self.send_SetMeta(feature_name, meta)
        self.recv_SetMeta()

    def send_SetMeta(self, feature_name, meta):
        self._oprot.writeMessageBegin('SetMeta', TMessageType.CALL, self._seqid)
        args = SetMeta_args()
        args.feature_name = feature_name
        args.meta = meta
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_SetMeta(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = SetMeta_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.error is not None:
            raise result.error
        return


class Processor(Iface, TProcessor):
    def __init__(self, handler):
        self._handler = handler
        self._processMap = {}
        self._processMap["Create"] = Processor.process_Create
        self._processMap["Get"] = Processor.process_Get
        self._processMap["Set"] = Processor.process_Set
        self._processMap["Delete"] = Processor.process_Delete
        self._processMap["List"] = Processor.process_List
        self._processMap["SetMeta"] = Processor.process_SetMeta

    def process(self, iprot, oprot):
        (name, type, seqid) = iprot.readMessageBegin()
        if name not in self._processMap:
            iprot.skip(TType.STRUCT)
            iprot.readMessageEnd()
            x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
            oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
            x.write(oprot)
            oprot.writeMessageEnd()
            oprot.trans.flush()
            return
        else:
            self._processMap[name](self, seqid, iprot, oprot)
        return True

    def process_Create(self, seqid, iprot, oprot):
        args = Create_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = Create_result()
        try:
            result.success = self._handler.Create(args.feature_name, args.is_enabled, args.client_data)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("Create", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_Get(self, seqid, iprot, oprot):
        args = Get_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = Get_result()
        try:
            result.success = self._handler.Get(args.feature_name)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("Get", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_Set(self, seqid, iprot, oprot):
        args = Set_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = Set_result()
        try:
            self._handler.Set(args.feature_name, args.is_enabled)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("Set", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_Delete(self, seqid, iprot, oprot):
        args = Delete_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = Delete_result()
        try:
            self._handler.Delete(args.feature_name)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("Delete", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_List(self, seqid, iprot, oprot):
        args = List_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = List_result()
        try:
            result.success = self._handler.List(args.limit, args.offset)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("List", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_SetMeta(self, seqid, iprot, oprot):
        args = SetMeta_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = SetMeta_result()
        try:
            self._handler.SetMeta(args.feature_name, args.meta)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except FlipperException as error:
            msg_type = TMessageType.REPLY
            result.error = error
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("SetMeta", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

# HELPER FUNCTIONS AND STRUCTURES


class Create_args(object):
    """
    Attributes:
     - feature_name
     - is_enabled
     - client_data
    """


    def __init__(self, feature_name=None, is_enabled=None, client_data=None,):
        self.feature_name = feature_name
        self.is_enabled = is_enabled
        self.client_data = client_data

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.feature_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.BOOL:
                    self.is_enabled = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.client_data = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Create_args')
        if self.feature_name is not None:
            oprot.writeFieldBegin('feature_name', TType.STRING, 1)
            oprot.writeString(self.feature_name.encode('utf-8') if sys.version_info[0] == 2 else self.feature_name)
            oprot.writeFieldEnd()
        if self.is_enabled is not None:
            oprot.writeFieldBegin('is_enabled', TType.BOOL, 2)
            oprot.writeBool(self.is_enabled)
            oprot.writeFieldEnd()
        if self.client_data is not None:
            oprot.writeFieldBegin('client_data', TType.STRING, 3)
            oprot.writeString(self.client_data.encode('utf-8') if sys.version_info[0] == 2 else self.client_data)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Create_args)
Create_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'feature_name', 'UTF8', None, ),  # 1
    (2, TType.BOOL, 'is_enabled', None, None, ),  # 2
    (3, TType.STRING, 'client_data', 'UTF8', None, ),  # 3
)


class Create_result(object):
    """
    Attributes:
     - success
     - error
    """


    def __init__(self, success=None, error=None,):
        self.success = success
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = FeatureFlagStoreItem()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Create_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Create_result)
Create_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [FeatureFlagStoreItem, None], None, ),  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)


class Get_args(object):
    """
    Attributes:
     - feature_name
    """


    def __init__(self, feature_name=None,):
        self.feature_name = feature_name

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.feature_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Get_args')
        if self.feature_name is not None:
            oprot.writeFieldBegin('feature_name', TType.STRING, 1)
            oprot.writeString(self.feature_name.encode('utf-8') if sys.version_info[0] == 2 else self.feature_name)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Get_args)
Get_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'feature_name', 'UTF8', None, ),  # 1
)


class Get_result(object):
    """
    Attributes:
     - success
     - error
    """


    def __init__(self, success=None, error=None,):
        self.success = success
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = FeatureFlagStoreItem()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Get_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Get_result)
Get_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [FeatureFlagStoreItem, None], None, ),  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)


class Set_args(object):
    """
    Attributes:
     - feature_name
     - is_enabled
    """


    def __init__(self, feature_name=None, is_enabled=None,):
        self.feature_name = feature_name
        self.is_enabled = is_enabled

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.feature_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.BOOL:
                    self.is_enabled = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Set_args')
        if self.feature_name is not None:
            oprot.writeFieldBegin('feature_name', TType.STRING, 1)
            oprot.writeString(self.feature_name.encode('utf-8') if sys.version_info[0] == 2 else self.feature_name)
            oprot.writeFieldEnd()
        if self.is_enabled is not None:
            oprot.writeFieldBegin('is_enabled', TType.BOOL, 2)
            oprot.writeBool(self.is_enabled)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Set_args)
Set_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'feature_name', 'UTF8', None, ),  # 1
    (2, TType.BOOL, 'is_enabled', None, None, ),  # 2
)


class Set_result(object):
    """
    Attributes:
     - error
    """


    def __init__(self, error=None,):
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Set_result')
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Set_result)
Set_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)


class Delete_args(object):
    """
    Attributes:
     - feature_name
    """


    def __init__(self, feature_name=None,):
        self.feature_name = feature_name

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.feature_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Delete_args')
        if self.feature_name is not None:
            oprot.writeFieldBegin('feature_name', TType.STRING, 1)
            oprot.writeString(self.feature_name.encode('utf-8') if sys.version_info[0] == 2 else self.feature_name)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Delete_args)
Delete_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'feature_name', 'UTF8', None, ),  # 1
)


class Delete_result(object):
    """
    Attributes:
     - error
    """


    def __init__(self, error=None,):
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Delete_result')
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Delete_result)
Delete_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)


class List_args(object):
    """
    Attributes:
     - limit
     - offset
    """


    def __init__(self, limit=None, offset=None,):
        self.limit = limit
        self.offset = offset

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I64:
                    self.limit = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.offset = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('List_args')
        if self.limit is not None:
            oprot.writeFieldBegin('limit', TType.I64, 1)
            oprot.writeI64(self.limit)
            oprot.writeFieldEnd()
        if self.offset is not None:
            oprot.writeFieldBegin('offset', TType.I64, 2)
            oprot.writeI64(self.offset)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(List_args)
List_args.thrift_spec = (
    None,  # 0
    (1, TType.I64, 'limit', None, None, ),  # 1
    (2, TType.I64, 'offset', None, None, ),  # 2
)


class List_result(object):
    """
    Attributes:
     - success
     - error
    """


    def __init__(self, success=None, error=None,):
        self.success = success
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype26, _size23) = iprot.readListBegin()
                    for _i27 in range(_size23):
                        _elem28 = FeatureFlagStoreItem()
                        _elem28.read(iprot)
                        self.success.append(_elem28)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('List_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter29 in self.success:
                iter29.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(List_result)
List_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [FeatureFlagStoreItem, None], False), None, ),  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)


class SetMeta_args(object):
    """
    Attributes:
     - feature_name
     - meta
    """


    def __init__(self, feature_name=None, meta=None,):
        self.feature_name = feature_name
        self.meta = meta

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.feature_name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.meta = FeatureFlagStoreMeta()
                    self.meta.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SetMeta_args')
        if self.feature_name is not None:
            oprot.writeFieldBegin('feature_name', TType.STRING, 1)
            oprot.writeString(self.feature_name.encode('utf-8') if sys.version_info[0] == 2 else self.feature_name)
            oprot.writeFieldEnd()
        if self.meta is not None:
            oprot.writeFieldBegin('meta', TType.STRUCT, 2)
            self.meta.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(SetMeta_args)
SetMeta_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'feature_name', 'UTF8', None, ),  # 1
    (2, TType.STRUCT, 'meta', [FeatureFlagStoreMeta, None], None, ),  # 2
)


class SetMeta_result(object):
    """
    Attributes:
     - error
    """


    def __init__(self, error=None,):
        self.error = error

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.error = FlipperException()
                    self.error.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SetMeta_result')
        if self.error is not None:
            oprot.writeFieldBegin('error', TType.STRUCT, 1)
            self.error.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(SetMeta_result)
SetMeta_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'error', [FlipperException, None], None, ),  # 1
)
fix_spec(all_structs)
del all_structs

