# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models import util


class ToolchainIntegrationSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, additional_environments: Dict[str, str]=None, default_image: str=None, entrypoint: str=None):  # noqa: E501
        """ToolchainIntegrationSpec - a model defined in Swagger

        :param additional_environments: The additional_environments of this ToolchainIntegrationSpec.  # noqa: E501
        :type additional_environments: Dict[str, str]
        :param default_image: The default_image of this ToolchainIntegrationSpec.  # noqa: E501
        :type default_image: str
        :param entrypoint: The entrypoint of this ToolchainIntegrationSpec.  # noqa: E501
        :type entrypoint: str
        """
        self.swagger_types = {
            'additional_environments': Dict[str, str],
            'default_image': str,
            'entrypoint': str
        }

        self.attribute_map = {
            'additional_environments': 'additionalEnvironments',
            'default_image': 'defaultImage',
            'entrypoint': 'entrypoint'
        }

        self._additional_environments = additional_environments
        self._default_image = default_image
        self._entrypoint = entrypoint

    @classmethod
    def from_dict(cls, dikt) -> 'ToolchainIntegrationSpec':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ToolchainIntegrationSpec of this ToolchainIntegrationSpec.  # noqa: E501
        :rtype: ToolchainIntegrationSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def additional_environments(self) -> Dict[str, str]:
        """Gets the additional_environments of this ToolchainIntegrationSpec.

        Additional environments for a training process  # noqa: E501

        :return: The additional_environments of this ToolchainIntegrationSpec.
        :rtype: Dict[str, str]
        """
        return self._additional_environments

    @additional_environments.setter
    def additional_environments(self, additional_environments: Dict[str, str]):
        """Sets the additional_environments of this ToolchainIntegrationSpec.

        Additional environments for a training process  # noqa: E501

        :param additional_environments: The additional_environments of this ToolchainIntegrationSpec.
        :type additional_environments: Dict[str, str]
        """

        self._additional_environments = additional_environments

    @property
    def default_image(self) -> str:
        """Gets the default_image of this ToolchainIntegrationSpec.

        Default training Docker image  # noqa: E501

        :return: The default_image of this ToolchainIntegrationSpec.
        :rtype: str
        """
        return self._default_image

    @default_image.setter
    def default_image(self, default_image: str):
        """Sets the default_image of this ToolchainIntegrationSpec.

        Default training Docker image  # noqa: E501

        :param default_image: The default_image of this ToolchainIntegrationSpec.
        :type default_image: str
        """

        self._default_image = default_image

    @property
    def entrypoint(self) -> str:
        """Gets the entrypoint of this ToolchainIntegrationSpec.

        Path to binary which starts a training process  # noqa: E501

        :return: The entrypoint of this ToolchainIntegrationSpec.
        :rtype: str
        """
        return self._entrypoint

    @entrypoint.setter
    def entrypoint(self, entrypoint: str):
        """Sets the entrypoint of this ToolchainIntegrationSpec.

        Path to binary which starts a training process  # noqa: E501

        :param entrypoint: The entrypoint of this ToolchainIntegrationSpec.
        :type entrypoint: str
        """

        self._entrypoint = entrypoint
