# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.inference_job_spec import InferenceJobSpec  # noqa: F401,E501
from odahuflow.sdk.models.inference_job_status import InferenceJobStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class InferenceJob(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, created_at: str=None, id: str=None, spec: InferenceJobSpec=None, status: InferenceJobStatus=None, updated_at: str=None):  # noqa: E501
        """InferenceJob - a model defined in Swagger

        :param created_at: The created_at of this InferenceJob.  # noqa: E501
        :type created_at: str
        :param id: The id of this InferenceJob.  # noqa: E501
        :type id: str
        :param spec: The spec of this InferenceJob.  # noqa: E501
        :type spec: InferenceJobSpec
        :param status: The status of this InferenceJob.  # noqa: E501
        :type status: InferenceJobStatus
        :param updated_at: The updated_at of this InferenceJob.  # noqa: E501
        :type updated_at: str
        """
        self.swagger_types = {
            'created_at': str,
            'id': str,
            'spec': InferenceJobSpec,
            'status': InferenceJobStatus,
            'updated_at': str
        }

        self.attribute_map = {
            'created_at': 'createdAt',
            'id': 'id',
            'spec': 'spec',
            'status': 'status',
            'updated_at': 'updatedAt'
        }

        self._created_at = created_at
        self._id = id
        self._spec = spec
        self._status = status
        self._updated_at = updated_at

    @classmethod
    def from_dict(cls, dikt) -> 'InferenceJob':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InferenceJob of this InferenceJob.  # noqa: E501
        :rtype: InferenceJob
        """
        return util.deserialize_model(dikt, cls)

    @property
    def created_at(self) -> str:
        """Gets the created_at of this InferenceJob.

        CreatedAt describes when InferenceJob was launched  # noqa: E501

        :return: The created_at of this InferenceJob.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at: str):
        """Sets the created_at of this InferenceJob.

        CreatedAt describes when InferenceJob was launched  # noqa: E501

        :param created_at: The created_at of this InferenceJob.
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def id(self) -> str:
        """Gets the id of this InferenceJob.

        Resource ID  # noqa: E501

        :return: The id of this InferenceJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this InferenceJob.

        Resource ID  # noqa: E501

        :param id: The id of this InferenceJob.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> InferenceJobSpec:
        """Gets the spec of this InferenceJob.

        Spec describes parameters of InferenceJob  # noqa: E501

        :return: The spec of this InferenceJob.
        :rtype: InferenceJobSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: InferenceJobSpec):
        """Sets the spec of this InferenceJob.

        Spec describes parameters of InferenceJob  # noqa: E501

        :param spec: The spec of this InferenceJob.
        :type spec: InferenceJobSpec
        """

        self._spec = spec

    @property
    def status(self) -> InferenceJobStatus:
        """Gets the status of this InferenceJob.

        Spec describes execution status of InferenceJob  # noqa: E501

        :return: The status of this InferenceJob.
        :rtype: InferenceJobStatus
        """
        return self._status

    @status.setter
    def status(self, status: InferenceJobStatus):
        """Sets the status of this InferenceJob.

        Spec describes execution status of InferenceJob  # noqa: E501

        :param status: The status of this InferenceJob.
        :type status: InferenceJobStatus
        """

        self._status = status

    @property
    def updated_at(self) -> str:
        """Gets the updated_at of this InferenceJob.

        CreatedAt describes when InferenceJob was updated (status was changed)  # noqa: E501

        :return: The updated_at of this InferenceJob.
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at: str):
        """Sets the updated_at of this InferenceJob.

        CreatedAt describes when InferenceJob was updated (status was changed)  # noqa: E501

        :param updated_at: The updated_at of this InferenceJob.
        :type updated_at: str
        """

        self._updated_at = updated_at
