# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.api_config import APIConfig  # noqa: F401,E501
from odahuflow.sdk.models.batch_config import BatchConfig  # noqa: F401,E501
from odahuflow.sdk.models.common_config import CommonConfig  # noqa: F401,E501
from odahuflow.sdk.models.connection_config import ConnectionConfig  # noqa: F401,E501
from odahuflow.sdk.models.model_deployment_config import ModelDeploymentConfig  # noqa: F401,E501
from odahuflow.sdk.models.model_packaging_config import ModelPackagingConfig  # noqa: F401,E501
from odahuflow.sdk.models.model_training_config import ModelTrainingConfig  # noqa: F401,E501
from odahuflow.sdk.models.operator_config import OperatorConfig  # noqa: F401,E501
from odahuflow.sdk.models.packager_config import PackagerConfig  # noqa: F401,E501
from odahuflow.sdk.models.service_catalog import ServiceCatalog  # noqa: F401,E501
from odahuflow.sdk.models.trainer_config import TrainerConfig  # noqa: F401,E501
from odahuflow.sdk.models.user_config import UserConfig  # noqa: F401,E501
from odahuflow.sdk.models import util


class Config(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, api: APIConfig=None, batch: BatchConfig=None, common: CommonConfig=None, connection: ConnectionConfig=None, deployment: ModelDeploymentConfig=None, operator: OperatorConfig=None, packager: PackagerConfig=None, packaging: ModelPackagingConfig=None, service_catalog: ServiceCatalog=None, trainer: TrainerConfig=None, training: ModelTrainingConfig=None, users: UserConfig=None):  # noqa: E501
        """Config - a model defined in Swagger

        :param api: The api of this Config.  # noqa: E501
        :type api: APIConfig
        :param batch: The batch of this Config.  # noqa: E501
        :type batch: BatchConfig
        :param common: The common of this Config.  # noqa: E501
        :type common: CommonConfig
        :param connection: The connection of this Config.  # noqa: E501
        :type connection: ConnectionConfig
        :param deployment: The deployment of this Config.  # noqa: E501
        :type deployment: ModelDeploymentConfig
        :param operator: The operator of this Config.  # noqa: E501
        :type operator: OperatorConfig
        :param packager: The packager of this Config.  # noqa: E501
        :type packager: PackagerConfig
        :param packaging: The packaging of this Config.  # noqa: E501
        :type packaging: ModelPackagingConfig
        :param service_catalog: The service_catalog of this Config.  # noqa: E501
        :type service_catalog: ServiceCatalog
        :param trainer: The trainer of this Config.  # noqa: E501
        :type trainer: TrainerConfig
        :param training: The training of this Config.  # noqa: E501
        :type training: ModelTrainingConfig
        :param users: The users of this Config.  # noqa: E501
        :type users: UserConfig
        """
        self.swagger_types = {
            'api': APIConfig,
            'batch': BatchConfig,
            'common': CommonConfig,
            'connection': ConnectionConfig,
            'deployment': ModelDeploymentConfig,
            'operator': OperatorConfig,
            'packager': PackagerConfig,
            'packaging': ModelPackagingConfig,
            'service_catalog': ServiceCatalog,
            'trainer': TrainerConfig,
            'training': ModelTrainingConfig,
            'users': UserConfig
        }

        self.attribute_map = {
            'api': 'api',
            'batch': 'batch',
            'common': 'common',
            'connection': 'connection',
            'deployment': 'deployment',
            'operator': 'operator',
            'packager': 'packager',
            'packaging': 'packaging',
            'service_catalog': 'serviceCatalog',
            'trainer': 'trainer',
            'training': 'training',
            'users': 'users'
        }

        self._api = api
        self._batch = batch
        self._common = common
        self._connection = connection
        self._deployment = deployment
        self._operator = operator
        self._packager = packager
        self._packaging = packaging
        self._service_catalog = service_catalog
        self._trainer = trainer
        self._training = training
        self._users = users

    @classmethod
    def from_dict(cls, dikt) -> 'Config':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Config of this Config.  # noqa: E501
        :rtype: Config
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api(self) -> APIConfig:
        """Gets the api of this Config.


        :return: The api of this Config.
        :rtype: APIConfig
        """
        return self._api

    @api.setter
    def api(self, api: APIConfig):
        """Sets the api of this Config.


        :param api: The api of this Config.
        :type api: APIConfig
        """

        self._api = api

    @property
    def batch(self) -> BatchConfig:
        """Gets the batch of this Config.


        :return: The batch of this Config.
        :rtype: BatchConfig
        """
        return self._batch

    @batch.setter
    def batch(self, batch: BatchConfig):
        """Sets the batch of this Config.


        :param batch: The batch of this Config.
        :type batch: BatchConfig
        """

        self._batch = batch

    @property
    def common(self) -> CommonConfig:
        """Gets the common of this Config.


        :return: The common of this Config.
        :rtype: CommonConfig
        """
        return self._common

    @common.setter
    def common(self, common: CommonConfig):
        """Sets the common of this Config.


        :param common: The common of this Config.
        :type common: CommonConfig
        """

        self._common = common

    @property
    def connection(self) -> ConnectionConfig:
        """Gets the connection of this Config.


        :return: The connection of this Config.
        :rtype: ConnectionConfig
        """
        return self._connection

    @connection.setter
    def connection(self, connection: ConnectionConfig):
        """Sets the connection of this Config.


        :param connection: The connection of this Config.
        :type connection: ConnectionConfig
        """

        self._connection = connection

    @property
    def deployment(self) -> ModelDeploymentConfig:
        """Gets the deployment of this Config.


        :return: The deployment of this Config.
        :rtype: ModelDeploymentConfig
        """
        return self._deployment

    @deployment.setter
    def deployment(self, deployment: ModelDeploymentConfig):
        """Sets the deployment of this Config.


        :param deployment: The deployment of this Config.
        :type deployment: ModelDeploymentConfig
        """

        self._deployment = deployment

    @property
    def operator(self) -> OperatorConfig:
        """Gets the operator of this Config.


        :return: The operator of this Config.
        :rtype: OperatorConfig
        """
        return self._operator

    @operator.setter
    def operator(self, operator: OperatorConfig):
        """Sets the operator of this Config.


        :param operator: The operator of this Config.
        :type operator: OperatorConfig
        """

        self._operator = operator

    @property
    def packager(self) -> PackagerConfig:
        """Gets the packager of this Config.


        :return: The packager of this Config.
        :rtype: PackagerConfig
        """
        return self._packager

    @packager.setter
    def packager(self, packager: PackagerConfig):
        """Sets the packager of this Config.


        :param packager: The packager of this Config.
        :type packager: PackagerConfig
        """

        self._packager = packager

    @property
    def packaging(self) -> ModelPackagingConfig:
        """Gets the packaging of this Config.


        :return: The packaging of this Config.
        :rtype: ModelPackagingConfig
        """
        return self._packaging

    @packaging.setter
    def packaging(self, packaging: ModelPackagingConfig):
        """Sets the packaging of this Config.


        :param packaging: The packaging of this Config.
        :type packaging: ModelPackagingConfig
        """

        self._packaging = packaging

    @property
    def service_catalog(self) -> ServiceCatalog:
        """Gets the service_catalog of this Config.


        :return: The service_catalog of this Config.
        :rtype: ServiceCatalog
        """
        return self._service_catalog

    @service_catalog.setter
    def service_catalog(self, service_catalog: ServiceCatalog):
        """Sets the service_catalog of this Config.


        :param service_catalog: The service_catalog of this Config.
        :type service_catalog: ServiceCatalog
        """

        self._service_catalog = service_catalog

    @property
    def trainer(self) -> TrainerConfig:
        """Gets the trainer of this Config.


        :return: The trainer of this Config.
        :rtype: TrainerConfig
        """
        return self._trainer

    @trainer.setter
    def trainer(self, trainer: TrainerConfig):
        """Sets the trainer of this Config.


        :param trainer: The trainer of this Config.
        :type trainer: TrainerConfig
        """

        self._trainer = trainer

    @property
    def training(self) -> ModelTrainingConfig:
        """Gets the training of this Config.


        :return: The training of this Config.
        :rtype: ModelTrainingConfig
        """
        return self._training

    @training.setter
    def training(self, training: ModelTrainingConfig):
        """Sets the training of this Config.


        :param training: The training of this Config.
        :type training: ModelTrainingConfig
        """

        self._training = training

    @property
    def users(self) -> UserConfig:
        """Gets the users of this Config.


        :return: The users of this Config.
        :rtype: UserConfig
        """
        return self._users

    @users.setter
    def users(self, users: UserConfig):
        """Sets the users of this Config.


        :param users: The users of this Config.
        :type users: UserConfig
        """

        self._users = users
