from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class StepCls:
	"""Step commands group definition. 1 total commands, 0 Subgroups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("step", core, parent)

	def set(self, stepsize: float) -> None:
		"""SCPI: SOURce:GENerator:FREQuency:STEP \n
		Snippet: driver.source.generator.frequency.step.set(stepsize = 1.0) \n
		This command defines the frequency stepsize of the signal generated by the optional signal source. \n
			:param stepsize: 1 mHz | 1 Hz | 1 kHz | 1 MHz | 1 GHz Unit: Hz
		"""
		param = Conversions.decimal_value_to_str(stepsize)
		self._core.io.write(f'SOURce:GENerator:FREQuency:STEP {param}')

	def get(self) -> float:
		"""SCPI: SOURce:GENerator:FREQuency:STEP \n
		Snippet: value: float = driver.source.generator.frequency.step.get() \n
		This command defines the frequency stepsize of the signal generated by the optional signal source. \n
			:return: stepsize: 1 mHz | 1 Hz | 1 kHz | 1 MHz | 1 GHz Unit: Hz"""
		response = self._core.io.query_str(f'SOURce:GENerator:FREQuency:STEP?')
		return Conversions.str_to_float(response)
