
import nonebot
from nonebot.plugin import on_shell_command, require
from nonebot.typing import T_State
from nonebot.adapters.cqhttp import (
    Bot,
    MessageEvent,
    PrivateMessageEvent,
    GroupMessageEvent,
)
from nonebot import get_bots
from mcstatus import MinecraftServer

from nonebot_plugin_mcstatus.data import ServerList
from nonebot_plugin_mcstatus.parser import mc_parser
from nonebot_plugin_mcstatus.handle import Handle

scheduler = require("nonebot_plugin_apscheduler").scheduler

# 注册 shell_like 事件响应器
mc = on_shell_command("mc", parser=mc_parser, priority=5)

# 每分钟进行一次检测
@scheduler.scheduled_job("cron", minute="*/5", id="mcstatus")
async def _():
    server_list = ServerList().get_server()
    bots = nonebot.get_bots()

    for type in server_list:
        for id in server_list[type]:
            for server in server_list[type][id]:
                old_status = server_list[type][id][server]["status"]
                address = server_list[type][id][server]["address"]
                try:
                    ping = await MinecraftServer.lookup(address).async_ping()
                    status = True
                except:
                    status = False
                if status != old_status:
                    for bot in bots:
                        bots[bot].send_msg(
                            user_id = id if type == "user" else None,
                            group_id = id if type == "group" else None,
                            message = (
                                "【服务器状态发生变化】"
                                f"Address: {address}\n"
                                f"Status: {'On' if status else 'Off'}\n"
                                f"Ping: {ping}" if status else "" 
                            )
                        )


@mc.handle()
async def _(bot: Bot, event: MessageEvent, state: T_State):
    args = state["args"]
    args.user_id = event.user_id if isinstance(event,PrivateMessageEvent) else None
    args.group_id = event.group_id if isinstance(event,GroupMessageEvent) else None
    args.is_admin = (
        event.sender.role in ["admin", "owner"]
        if isinstance(event, GroupMessageEvent)
        else False
    )
    if hasattr(args, "handle"):
        await bot.send(event,await getattr(Handle, args.handle)(args))