# -*- coding: utf-8 -*-
#
# Copyright 2022 Sanhe Hu <https://github.com/MacHu-GWU/aws_stepfunction-project>

"""
"""

from ._version import __version__

__short_description__ = "Yet the most developer friendly orchestration tool on AWS."
__license__ = "MIT"
__author__ = "Sanhe Hu"
__author_email__ = "husanhe@gmail.com"
__github_username__ = "MacHu-GWU"

# ------------------------------------------------------------------------------
# Public API
# ------------------------------------------------------------------------------
try:
    from .workflow import Workflow
    from .state import (
        State,
        Task, Parallel, Map, Pass, Wait, Choice, Succeed, Fail,
        Retry, Catch,
    )
    from .magic import LambdaTask
    from .choice_rule import (
        ChoiceRule,
        and_, or_, not_,
        Var,
    )
    from . import actions
    from .actions import task_context
    from .state_machine import StateMachine
    from .constant import Constant
except ImportError as e:  # pragma: no cover
    print(e)
