# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import PostgreSQLManagementClientConfiguration
from .operations import ServersOperations
from .operations import FirewallRulesOperations
from .operations import ConfigurationsOperations
from .operations import ServerKeysOperations
from .operations import CheckNameAvailabilityOperations
from .operations import LocationBasedCapabilitiesOperations
from .operations import VirtualNetworkSubnetUsageOperations
from .operations import Operations
from . import models


class PostgreSQLManagementClient(SDKClient):
    """The Microsoft Azure management API provides create, read, update, and delete functionality for Azure PostgreSQL resources including servers, databases, firewall rules, VNET rules, security alert policies, log files and configurations with new business model.

    :ivar config: Configuration for client.
    :vartype config: PostgreSQLManagementClientConfiguration

    :ivar servers: Servers operations
    :vartype servers: azure.mgmt.rdbms.postgresql_flexibleservers.operations.ServersOperations
    :ivar firewall_rules: FirewallRules operations
    :vartype firewall_rules: azure.mgmt.rdbms.postgresql_flexibleservers.operations.FirewallRulesOperations
    :ivar configurations: Configurations operations
    :vartype configurations: azure.mgmt.rdbms.postgresql_flexibleservers.operations.ConfigurationsOperations
    :ivar server_keys: ServerKeys operations
    :vartype server_keys: azure.mgmt.rdbms.postgresql_flexibleservers.operations.ServerKeysOperations
    :ivar check_name_availability: CheckNameAvailability operations
    :vartype check_name_availability: azure.mgmt.rdbms.postgresql_flexibleservers.operations.CheckNameAvailabilityOperations
    :ivar location_based_capabilities: LocationBasedCapabilities operations
    :vartype location_based_capabilities: azure.mgmt.rdbms.postgresql_flexibleservers.operations.LocationBasedCapabilitiesOperations
    :ivar virtual_network_subnet_usage: VirtualNetworkSubnetUsage operations
    :vartype virtual_network_subnet_usage: azure.mgmt.rdbms.postgresql_flexibleservers.operations.VirtualNetworkSubnetUsageOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.rdbms.postgresql_flexibleservers.operations.Operations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = PostgreSQLManagementClientConfiguration(credentials, subscription_id, base_url)
        super(PostgreSQLManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-02-14-privatepreview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.servers = ServersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.firewall_rules = FirewallRulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.configurations = ConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.server_keys = ServerKeysOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.check_name_availability = CheckNameAvailabilityOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.location_based_capabilities = LocationBasedCapabilitiesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_network_subnet_usage = VirtualNetworkSubnetUsageOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
