# coding: utf-8


"""
IGNORE:
    Nutanix Aiops Versioned APIs

    Manage infrastructure on-premises and in the cloud seamlessly through AIOps features such as Analysis, Reporting, Capacity Planning, What if Analysis, VM Rightsizing, Troubleshooting, App Discovery, Broad Observability, and Ops Automation through Playbooks.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_aiops_py_client.Ntnx.aiops.v4.blackout.ClusterEntity import ClusterEntity  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class BlackoutPeriod(object):
    """BlackoutPeriod - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'uuid': 'str',
        'name': 'str',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'cluster_type': 'aiops.v4.blackout.ClusterEntity',
        'cluster_uuid': 'str',
        'resources': 'list[str]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'uuid': 'uuid',
        'name': 'name',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'cluster_type': 'clusterType',
        'cluster_uuid': 'clusterUuid',
        'resources': 'resources',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, uuid=None, name=None, start_time=None, end_time=None, cluster_type=None, cluster_uuid=None, resources=None, *args, **kwargs):  # noqa: E501
        """BlackoutPeriod - a model defined in Swagger
            
        """
        self.__uuid = None
        self.__name = None
        self.__start_time = None
        self.__end_time = None
        self.__cluster_type = None
        self.__cluster_uuid = None
        self.__resources = None
        self.discriminator = None
        if uuid is not None:
            self.__uuid = uuid
        if name is not None:
            self.__name = name
        if start_time is not None:
            self.__start_time = start_time
        if end_time is not None:
            self.__end_time = end_time
        if cluster_type is not None:
            self.__cluster_type = cluster_type
        if cluster_uuid is not None:
            self.__cluster_uuid = cluster_uuid
        if resources is not None:
            self.__resources = resources
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'aiops.v4.blackout.BlackoutPeriod'

    def _initialize_fq_object_type(self):
        return 'aiops.v4.r0.a1.blackout.BlackoutPeriod'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def uuid(self):
        """`{ str }`
            \nUUID of the blackout period created.
        """ # noqa: E501
        return self.__uuid

    @uuid.setter
    def uuid(self, uuid):
        if uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__uuid = uuid

    @property
    def name(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is not None and len(name) > 256:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `256`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self.__name = name

    @property
    def start_time(self):
        """`{ datetime }`
            \nStart timestamp of the blackout period.
        """ # noqa: E501
        return self.__start_time

    @start_time.setter
    def start_time(self, start_time):

        self.__start_time = start_time

    @property
    def end_time(self):
        """`{ datetime }`
            \nEnd timestamp of the blackout period.
        """ # noqa: E501
        return self.__end_time

    @end_time.setter
    def end_time(self, end_time):

        self.__end_time = end_time

    @property
    def cluster_type(self):
        """`{ aiops.v4.blackout.ClusterEntity }`
            
        """ # noqa: E501
        return self.__cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):

        self.__cluster_type = cluster_type

    @property
    def cluster_uuid(self):
        """`{ str }`
            \nCluster UUID
        """ # noqa: E501
        return self.__cluster_uuid

    @cluster_uuid.setter
    def cluster_uuid(self, cluster_uuid):

        self.__cluster_uuid = cluster_uuid

    @property
    def resources(self):
        """`{ list[str] }`
            \nResources (cpu / memory / storage) for which blackout period is defined.
        """ # noqa: E501
        return self.__resources

    @resources.setter
    def resources(self, resources):

        self.__resources = resources

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(BlackoutPeriod, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlackoutPeriod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

