"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPlaybackConfiguration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-03-14T15:31:03.623Z","fingerprint":"fI3CMOJCypndICBSu/B1M7Y7OpZRra7/HZiJSxx7kaU="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnPlaybackConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnPlaybackConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adDecisionServerUrl', cdk.requiredValidator)(properties.adDecisionServerUrl));
    errors.collect(cdk.propertyValidator('adDecisionServerUrl', cdk.validateString)(properties.adDecisionServerUrl));
    errors.collect(cdk.propertyValidator('availSuppression', CfnPlaybackConfiguration_AvailSuppressionPropertyValidator)(properties.availSuppression));
    errors.collect(cdk.propertyValidator('bumper', CfnPlaybackConfiguration_BumperPropertyValidator)(properties.bumper));
    errors.collect(cdk.propertyValidator('cdnConfiguration', CfnPlaybackConfiguration_CdnConfigurationPropertyValidator)(properties.cdnConfiguration));
    errors.collect(cdk.propertyValidator('configurationAliases', cdk.hashValidator(cdk.validateObject))(properties.configurationAliases));
    errors.collect(cdk.propertyValidator('dashConfiguration', CfnPlaybackConfiguration_DashConfigurationPropertyValidator)(properties.dashConfiguration));
    errors.collect(cdk.propertyValidator('hlsConfiguration', CfnPlaybackConfiguration_HlsConfigurationPropertyValidator)(properties.hlsConfiguration));
    errors.collect(cdk.propertyValidator('livePreRollConfiguration', CfnPlaybackConfiguration_LivePreRollConfigurationPropertyValidator)(properties.livePreRollConfiguration));
    errors.collect(cdk.propertyValidator('manifestProcessingRules', CfnPlaybackConfiguration_ManifestProcessingRulesPropertyValidator)(properties.manifestProcessingRules));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('personalizationThresholdSeconds', cdk.validateNumber)(properties.personalizationThresholdSeconds));
    errors.collect(cdk.propertyValidator('slateAdUrl', cdk.validateString)(properties.slateAdUrl));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('transcodeProfileName', cdk.validateString)(properties.transcodeProfileName));
    errors.collect(cdk.propertyValidator('videoContentSourceUrl', cdk.requiredValidator)(properties.videoContentSourceUrl));
    errors.collect(cdk.propertyValidator('videoContentSourceUrl', cdk.validateString)(properties.videoContentSourceUrl));
    return errors.wrap('supplied properties not correct for "CfnPlaybackConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnPlaybackConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfigurationPropsValidator(properties).assertSuccess();
    return {
        AdDecisionServerUrl: cdk.stringToCloudFormation(properties.adDecisionServerUrl),
        Name: cdk.stringToCloudFormation(properties.name),
        VideoContentSourceUrl: cdk.stringToCloudFormation(properties.videoContentSourceUrl),
        AvailSuppression: cfnPlaybackConfigurationAvailSuppressionPropertyToCloudFormation(properties.availSuppression),
        Bumper: cfnPlaybackConfigurationBumperPropertyToCloudFormation(properties.bumper),
        CdnConfiguration: cfnPlaybackConfigurationCdnConfigurationPropertyToCloudFormation(properties.cdnConfiguration),
        ConfigurationAliases: cdk.hashMapper(cdk.objectToCloudFormation)(properties.configurationAliases),
        DashConfiguration: cfnPlaybackConfigurationDashConfigurationPropertyToCloudFormation(properties.dashConfiguration),
        HlsConfiguration: cfnPlaybackConfigurationHlsConfigurationPropertyToCloudFormation(properties.hlsConfiguration),
        LivePreRollConfiguration: cfnPlaybackConfigurationLivePreRollConfigurationPropertyToCloudFormation(properties.livePreRollConfiguration),
        ManifestProcessingRules: cfnPlaybackConfigurationManifestProcessingRulesPropertyToCloudFormation(properties.manifestProcessingRules),
        PersonalizationThresholdSeconds: cdk.numberToCloudFormation(properties.personalizationThresholdSeconds),
        SlateAdUrl: cdk.stringToCloudFormation(properties.slateAdUrl),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TranscodeProfileName: cdk.stringToCloudFormation(properties.transcodeProfileName),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adDecisionServerUrl', 'AdDecisionServerUrl', cfn_parse.FromCloudFormation.getString(properties.AdDecisionServerUrl));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('videoContentSourceUrl', 'VideoContentSourceUrl', cfn_parse.FromCloudFormation.getString(properties.VideoContentSourceUrl));
    ret.addPropertyResult('availSuppression', 'AvailSuppression', properties.AvailSuppression != null ? CfnPlaybackConfigurationAvailSuppressionPropertyFromCloudFormation(properties.AvailSuppression) : undefined);
    ret.addPropertyResult('bumper', 'Bumper', properties.Bumper != null ? CfnPlaybackConfigurationBumperPropertyFromCloudFormation(properties.Bumper) : undefined);
    ret.addPropertyResult('cdnConfiguration', 'CdnConfiguration', properties.CdnConfiguration != null ? CfnPlaybackConfigurationCdnConfigurationPropertyFromCloudFormation(properties.CdnConfiguration) : undefined);
    ret.addPropertyResult('configurationAliases', 'ConfigurationAliases', properties.ConfigurationAliases != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getAny)(properties.ConfigurationAliases) : undefined);
    ret.addPropertyResult('dashConfiguration', 'DashConfiguration', properties.DashConfiguration != null ? CfnPlaybackConfigurationDashConfigurationPropertyFromCloudFormation(properties.DashConfiguration) : undefined);
    ret.addPropertyResult('hlsConfiguration', 'HlsConfiguration', properties.HlsConfiguration != null ? CfnPlaybackConfigurationHlsConfigurationPropertyFromCloudFormation(properties.HlsConfiguration) : undefined);
    ret.addPropertyResult('livePreRollConfiguration', 'LivePreRollConfiguration', properties.LivePreRollConfiguration != null ? CfnPlaybackConfigurationLivePreRollConfigurationPropertyFromCloudFormation(properties.LivePreRollConfiguration) : undefined);
    ret.addPropertyResult('manifestProcessingRules', 'ManifestProcessingRules', properties.ManifestProcessingRules != null ? CfnPlaybackConfigurationManifestProcessingRulesPropertyFromCloudFormation(properties.ManifestProcessingRules) : undefined);
    ret.addPropertyResult('personalizationThresholdSeconds', 'PersonalizationThresholdSeconds', properties.PersonalizationThresholdSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.PersonalizationThresholdSeconds) : undefined);
    ret.addPropertyResult('slateAdUrl', 'SlateAdUrl', properties.SlateAdUrl != null ? cfn_parse.FromCloudFormation.getString(properties.SlateAdUrl) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('transcodeProfileName', 'TranscodeProfileName', properties.TranscodeProfileName != null ? cfn_parse.FromCloudFormation.getString(properties.TranscodeProfileName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaTailor::PlaybackConfiguration`
 *
 * Adds a new playback configuration to AWS Elemental MediaTailor .
 *
 * @cloudformationResource AWS::MediaTailor::PlaybackConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html
 */
class CfnPlaybackConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaTailor::PlaybackConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPlaybackConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_mediatailor_CfnPlaybackConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPlaybackConfiguration);
            }
            throw error;
        }
        cdk.requireProperty(props, 'adDecisionServerUrl', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'videoContentSourceUrl', this);
        this.attrDashConfigurationManifestEndpointPrefix = cdk.Token.asString(this.getAtt('DashConfiguration.ManifestEndpointPrefix'));
        this.attrHlsConfigurationManifestEndpointPrefix = cdk.Token.asString(this.getAtt('HlsConfiguration.ManifestEndpointPrefix'));
        this.attrPlaybackConfigurationArn = cdk.Token.asString(this.getAtt('PlaybackConfigurationArn'));
        this.attrPlaybackEndpointPrefix = cdk.Token.asString(this.getAtt('PlaybackEndpointPrefix'));
        this.attrSessionInitializationEndpointPrefix = cdk.Token.asString(this.getAtt('SessionInitializationEndpointPrefix'));
        this.adDecisionServerUrl = props.adDecisionServerUrl;
        this.name = props.name;
        this.videoContentSourceUrl = props.videoContentSourceUrl;
        this.availSuppression = props.availSuppression;
        this.bumper = props.bumper;
        this.cdnConfiguration = props.cdnConfiguration;
        this.configurationAliases = props.configurationAliases;
        this.dashConfiguration = props.dashConfiguration;
        this.hlsConfiguration = props.hlsConfiguration;
        this.livePreRollConfiguration = props.livePreRollConfiguration;
        this.manifestProcessingRules = props.manifestProcessingRules;
        this.personalizationThresholdSeconds = props.personalizationThresholdSeconds;
        this.slateAdUrl = props.slateAdUrl;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaTailor::PlaybackConfiguration", props.tags, { tagPropertyName: 'tags' });
        this.transcodeProfileName = props.transcodeProfileName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPlaybackConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPlaybackConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPlaybackConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            adDecisionServerUrl: this.adDecisionServerUrl,
            name: this.name,
            videoContentSourceUrl: this.videoContentSourceUrl,
            availSuppression: this.availSuppression,
            bumper: this.bumper,
            cdnConfiguration: this.cdnConfiguration,
            configurationAliases: this.configurationAliases,
            dashConfiguration: this.dashConfiguration,
            hlsConfiguration: this.hlsConfiguration,
            livePreRollConfiguration: this.livePreRollConfiguration,
            manifestProcessingRules: this.manifestProcessingRules,
            personalizationThresholdSeconds: this.personalizationThresholdSeconds,
            slateAdUrl: this.slateAdUrl,
            tags: this.tags.renderTags(),
            transcodeProfileName: this.transcodeProfileName,
        };
    }
    renderProperties(props) {
        return cfnPlaybackConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnPlaybackConfiguration = CfnPlaybackConfiguration;
_a = JSII_RTTI_SYMBOL_1;
CfnPlaybackConfiguration[_a] = { fqn: "@aws-cdk/aws-mediatailor.CfnPlaybackConfiguration", version: "1.197.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPlaybackConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::MediaTailor::PlaybackConfiguration";
/**
 * Determine whether the given properties match those of a `AdMarkerPassthroughProperty`
 *
 * @param properties - the TypeScript properties of a `AdMarkerPassthroughProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_AdMarkerPassthroughPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    return errors.wrap('supplied properties not correct for "AdMarkerPassthroughProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.AdMarkerPassthrough` resource
 *
 * @param properties - the TypeScript properties of a `AdMarkerPassthroughProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.AdMarkerPassthrough` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationAdMarkerPassthroughPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_AdMarkerPassthroughPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationAdMarkerPassthroughPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AvailSuppressionProperty`
 *
 * @param properties - the TypeScript properties of a `AvailSuppressionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_AvailSuppressionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "AvailSuppressionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.AvailSuppression` resource
 *
 * @param properties - the TypeScript properties of a `AvailSuppressionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.AvailSuppression` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationAvailSuppressionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_AvailSuppressionPropertyValidator(properties).assertSuccess();
    return {
        Mode: cdk.stringToCloudFormation(properties.mode),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationAvailSuppressionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mode', 'Mode', properties.Mode != null ? cfn_parse.FromCloudFormation.getString(properties.Mode) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BumperProperty`
 *
 * @param properties - the TypeScript properties of a `BumperProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_BumperPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endUrl', cdk.validateString)(properties.endUrl));
    errors.collect(cdk.propertyValidator('startUrl', cdk.validateString)(properties.startUrl));
    return errors.wrap('supplied properties not correct for "BumperProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.Bumper` resource
 *
 * @param properties - the TypeScript properties of a `BumperProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.Bumper` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationBumperPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_BumperPropertyValidator(properties).assertSuccess();
    return {
        EndUrl: cdk.stringToCloudFormation(properties.endUrl),
        StartUrl: cdk.stringToCloudFormation(properties.startUrl),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationBumperPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endUrl', 'EndUrl', properties.EndUrl != null ? cfn_parse.FromCloudFormation.getString(properties.EndUrl) : undefined);
    ret.addPropertyResult('startUrl', 'StartUrl', properties.StartUrl != null ? cfn_parse.FromCloudFormation.getString(properties.StartUrl) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CdnConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `CdnConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_CdnConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adSegmentUrlPrefix', cdk.validateString)(properties.adSegmentUrlPrefix));
    errors.collect(cdk.propertyValidator('contentSegmentUrlPrefix', cdk.validateString)(properties.contentSegmentUrlPrefix));
    return errors.wrap('supplied properties not correct for "CdnConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.CdnConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CdnConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.CdnConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationCdnConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_CdnConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AdSegmentUrlPrefix: cdk.stringToCloudFormation(properties.adSegmentUrlPrefix),
        ContentSegmentUrlPrefix: cdk.stringToCloudFormation(properties.contentSegmentUrlPrefix),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationCdnConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adSegmentUrlPrefix', 'AdSegmentUrlPrefix', properties.AdSegmentUrlPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.AdSegmentUrlPrefix) : undefined);
    ret.addPropertyResult('contentSegmentUrlPrefix', 'ContentSegmentUrlPrefix', properties.ContentSegmentUrlPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.ContentSegmentUrlPrefix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DashConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_DashConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('manifestEndpointPrefix', cdk.validateString)(properties.manifestEndpointPrefix));
    errors.collect(cdk.propertyValidator('mpdLocation', cdk.validateString)(properties.mpdLocation));
    errors.collect(cdk.propertyValidator('originManifestType', cdk.validateString)(properties.originManifestType));
    return errors.wrap('supplied properties not correct for "DashConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.DashConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DashConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.DashConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationDashConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_DashConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ManifestEndpointPrefix: cdk.stringToCloudFormation(properties.manifestEndpointPrefix),
        MpdLocation: cdk.stringToCloudFormation(properties.mpdLocation),
        OriginManifestType: cdk.stringToCloudFormation(properties.originManifestType),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationDashConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('manifestEndpointPrefix', 'ManifestEndpointPrefix', properties.ManifestEndpointPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestEndpointPrefix) : undefined);
    ret.addPropertyResult('mpdLocation', 'MpdLocation', properties.MpdLocation != null ? cfn_parse.FromCloudFormation.getString(properties.MpdLocation) : undefined);
    ret.addPropertyResult('originManifestType', 'OriginManifestType', properties.OriginManifestType != null ? cfn_parse.FromCloudFormation.getString(properties.OriginManifestType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `HlsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_HlsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('manifestEndpointPrefix', cdk.validateString)(properties.manifestEndpointPrefix));
    return errors.wrap('supplied properties not correct for "HlsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.HlsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `HlsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.HlsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationHlsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_HlsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ManifestEndpointPrefix: cdk.stringToCloudFormation(properties.manifestEndpointPrefix),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationHlsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('manifestEndpointPrefix', 'ManifestEndpointPrefix', properties.ManifestEndpointPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestEndpointPrefix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LivePreRollConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LivePreRollConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_LivePreRollConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adDecisionServerUrl', cdk.validateString)(properties.adDecisionServerUrl));
    errors.collect(cdk.propertyValidator('maxDurationSeconds', cdk.validateNumber)(properties.maxDurationSeconds));
    return errors.wrap('supplied properties not correct for "LivePreRollConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.LivePreRollConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LivePreRollConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.LivePreRollConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationLivePreRollConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_LivePreRollConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AdDecisionServerUrl: cdk.stringToCloudFormation(properties.adDecisionServerUrl),
        MaxDurationSeconds: cdk.numberToCloudFormation(properties.maxDurationSeconds),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationLivePreRollConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adDecisionServerUrl', 'AdDecisionServerUrl', properties.AdDecisionServerUrl != null ? cfn_parse.FromCloudFormation.getString(properties.AdDecisionServerUrl) : undefined);
    ret.addPropertyResult('maxDurationSeconds', 'MaxDurationSeconds', properties.MaxDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxDurationSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ManifestProcessingRulesProperty`
 *
 * @param properties - the TypeScript properties of a `ManifestProcessingRulesProperty`
 *
 * @returns the result of the validation.
 */
function CfnPlaybackConfiguration_ManifestProcessingRulesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adMarkerPassthrough', CfnPlaybackConfiguration_AdMarkerPassthroughPropertyValidator)(properties.adMarkerPassthrough));
    return errors.wrap('supplied properties not correct for "ManifestProcessingRulesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.ManifestProcessingRules` resource
 *
 * @param properties - the TypeScript properties of a `ManifestProcessingRulesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaTailor::PlaybackConfiguration.ManifestProcessingRules` resource.
 */
// @ts-ignore TS6133
function cfnPlaybackConfigurationManifestProcessingRulesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPlaybackConfiguration_ManifestProcessingRulesPropertyValidator(properties).assertSuccess();
    return {
        AdMarkerPassthrough: cfnPlaybackConfigurationAdMarkerPassthroughPropertyToCloudFormation(properties.adMarkerPassthrough),
    };
}
// @ts-ignore TS6133
function CfnPlaybackConfigurationManifestProcessingRulesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adMarkerPassthrough', 'AdMarkerPassthrough', properties.AdMarkerPassthrough != null ? CfnPlaybackConfigurationAdMarkerPassthroughPropertyFromCloudFormation(properties.AdMarkerPassthrough) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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