import { Construct } from 'constructs';
import { UserPoolIdentityProviderBase, UserPoolIdentityProviderProps } from './base';
/**
 * (experimental) Properties to initialize UserPoolGoogleIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderGoogleProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by Google APIs.
     *
     * @see https://developers.google.com/identity/sign-in/web/sign-in#specify_your_apps_client_id
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientId for Google APIs to authenticate the client.
     *
     * @see https://developers.google.com/identity/sign-in/web/sign-in
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The list of google permissions to obtain for getting access to the google profile.
     *
     * @default [ profile ]
     * @see https://developers.google.com/identity/sign-in/web/sign-in
     * @experimental
     */
    readonly scopes?: string[];
}
/**
 * (experimental) Represents a identity provider that integrates with 'Google'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderGoogle extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderGoogleProps);
}
