/**
 * (experimental) The set of standard attributes that can be marked as required or mutable.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes
 * @experimental
 */
export interface StandardAttributes {
    /**
     * (experimental) The user's postal address.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly address?: StandardAttribute;
    /**
     * (experimental) The user's birthday, represented as an ISO 8601:2004 format.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly birthdate?: StandardAttribute;
    /**
     * (experimental) The user's e-mail address, represented as an RFC 5322 [RFC5322] addr-spec.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly email?: StandardAttribute;
    /**
     * (experimental) The surname or last name of the user.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly familyName?: StandardAttribute;
    /**
     * (experimental) The user's gender.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly gender?: StandardAttribute;
    /**
     * (experimental) The user's first name or give name.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly givenName?: StandardAttribute;
    /**
     * (experimental) The user's locale, represented as a BCP47 [RFC5646] language tag.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly locale?: StandardAttribute;
    /**
     * (experimental) The user's middle name.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly middleName?: StandardAttribute;
    /**
     * (experimental) The user's full name in displayable form, including all name parts, titles and suffixes.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly fullname?: StandardAttribute;
    /**
     * (experimental) The user's nickname or casual name.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly nickname?: StandardAttribute;
    /**
     * (experimental) The user's telephone number.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly phoneNumber?: StandardAttribute;
    /**
     * (experimental) The URL to the user's profile picture.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly profilePicture?: StandardAttribute;
    /**
     * (experimental) The user's preffered username, different from the immutable user name.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly preferredUsername?: StandardAttribute;
    /**
     * (experimental) The URL to the user's profile page.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly profilePage?: StandardAttribute;
    /**
     * (experimental) The user's time zone.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly timezone?: StandardAttribute;
    /**
     * (experimental) The time, the user's information was last updated.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly lastUpdateTime?: StandardAttribute;
    /**
     * (experimental) The URL to the user's web page or blog.
     *
     * @default - see the defaults under `StandardAttribute`
     * @experimental
     */
    readonly website?: StandardAttribute;
}
/**
 * (experimental) Standard attribute that can be marked as required or mutable.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes
 * @experimental
 */
export interface StandardAttribute {
    /**
     * (experimental) Specifies whether the value of the attribute can be changed.
     *
     * For any user pool attribute that's mapped to an identity provider attribute, this must be set to `true`.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     *
     * @default true
     * @experimental
     */
    readonly mutable?: boolean;
    /**
     * (experimental) Specifies whether the attribute is required upon user registration.
     *
     * If the attribute is required and the user does not provide a value, registration or sign-in will fail.
     *
     * @default false
     * @experimental
     */
    readonly required?: boolean;
}
/**
 * (experimental) Represents a custom attribute type.
 *
 * @experimental
 */
export interface ICustomAttribute {
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind(): CustomAttributeConfig;
}
/**
 * (experimental) Configuration that will be fed into CloudFormation for any custom attribute type.
 *
 * @experimental
 */
export interface CustomAttributeConfig {
    /**
     * (experimental) The data type of the custom attribute.
     *
     * @see https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SchemaAttributeType.html#CognitoUserPools-Type-SchemaAttributeType-AttributeDataType
     * @experimental
     */
    readonly dataType: string;
    /**
     * (experimental) The constraints for a custom attribute of 'String' data type.
     *
     * @default - None.
     * @experimental
     */
    readonly stringConstraints?: StringAttributeConstraints;
    /**
     * (experimental) The constraints for a custom attribute of the 'Number' data type.
     *
     * @default - None.
     * @experimental
     */
    readonly numberConstraints?: NumberAttributeConstraints;
    /**
     * (experimental) Specifies whether the value of the attribute can be changed.
     *
     * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     *
     * @default false
     * @experimental
     */
    readonly mutable?: boolean;
}
/**
 * (experimental) Constraints that can be applied to a custom attribute of any type.
 *
 * @experimental
 */
export interface CustomAttributeProps {
    /**
     * (experimental) Specifies whether the value of the attribute can be changed.
     *
     * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     *
     * @default false
     * @experimental
     */
    readonly mutable?: boolean;
}
/**
 * (experimental) Constraints that can be applied to a custom attribute of string type.
 *
 * @experimental
 */
export interface StringAttributeConstraints {
    /**
     * (experimental) Minimum length of this attribute.
     *
     * @default 0
     * @experimental
     */
    readonly minLen?: number;
    /**
     * (experimental) Maximum length of this attribute.
     *
     * @default 2048
     * @experimental
     */
    readonly maxLen?: number;
}
/**
 * (experimental) Props for constructing a StringAttr.
 *
 * @experimental
 */
export interface StringAttributeProps extends StringAttributeConstraints, CustomAttributeProps {
}
/**
 * (experimental) The String custom attribute type.
 *
 * @experimental
 */
export declare class StringAttribute implements ICustomAttribute {
    private readonly minLen?;
    private readonly maxLen?;
    private readonly mutable?;
    /**
     * @experimental
     */
    constructor(props?: StringAttributeProps);
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind(): CustomAttributeConfig;
}
/**
 * (experimental) Constraints that can be applied to a custom attribute of number type.
 *
 * @experimental
 */
export interface NumberAttributeConstraints {
    /**
     * (experimental) Minimum value of this attribute.
     *
     * @default - no minimum value
     * @experimental
     */
    readonly min?: number;
    /**
     * (experimental) Maximum value of this attribute.
     *
     * @default - no maximum value
     * @experimental
     */
    readonly max?: number;
}
/**
 * (experimental) Props for NumberAttr.
 *
 * @experimental
 */
export interface NumberAttributeProps extends NumberAttributeConstraints, CustomAttributeProps {
}
/**
 * (experimental) The Number custom attribute type.
 *
 * @experimental
 */
export declare class NumberAttribute implements ICustomAttribute {
    private readonly min?;
    private readonly max?;
    private readonly mutable?;
    /**
     * @experimental
     */
    constructor(props?: NumberAttributeProps);
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind(): CustomAttributeConfig;
}
/**
 * (experimental) The Boolean custom attribute type.
 *
 * @experimental
 */
export declare class BooleanAttribute implements ICustomAttribute {
    private readonly mutable?;
    /**
     * @experimental
     */
    constructor(props?: CustomAttributeProps);
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind(): CustomAttributeConfig;
}
/**
 * (experimental) The DateTime custom attribute type.
 *
 * @experimental
 */
export declare class DateTimeAttribute implements ICustomAttribute {
    private readonly mutable?;
    /**
     * @experimental
     */
    constructor(props?: CustomAttributeProps);
    /**
     * (experimental) Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @experimental
     */
    bind(): CustomAttributeConfig;
}
