"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterLogicalId = exports.formatFailure = exports.formatAllMatches = exports.matchSection = void 0;
const match_1 = require("../match");
const matcher_1 = require("../matcher");
function matchSection(section, props) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let matching = {};
    let count = 0;
    eachEntryInSection(section, (logicalId, entry) => {
        const result = matcher.test(entry);
        result.finished();
        if (!result.hasFailed()) {
            matching[logicalId] = entry;
        }
        else {
            count++;
            if (closestResult === undefined || closestResult.failCount > result.failCount) {
                closestResult = result;
            }
        }
    });
    if (Object.keys(matching).length > 0) {
        return { match: true, matches: matching };
    }
    else {
        return { match: false, closestResult, analyzedCount: count };
    }
}
exports.matchSection = matchSection;
function eachEntryInSection(section, cb) {
    for (const logicalId of Object.keys(section ?? {})) {
        const resource = section[logicalId];
        cb(logicalId, resource);
    }
}
function formatAllMatches(matches) {
    return [
        leftPad(JSON.stringify(matches, undefined, 2)),
    ].join('\n');
}
exports.formatAllMatches = formatAllMatches;
function formatFailure(closestResult) {
    return [
        'The closest result is:',
        leftPad(JSON.stringify(closestResult.target, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
exports.formatFailure = formatFailure;
function leftPad(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
function filterLogicalId(section, logicalId) {
    // default signal for all logicalIds is '*'
    if (logicalId === '*')
        return section;
    return Object.entries(section ?? {})
        .filter(([k, _]) => k === logicalId)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
exports.filterLogicalId = filterLogicalId;
//# sourceMappingURL=data:application/json;base64,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