"use strict";
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUTURE_FLAGS = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = "ros-cdk:enableStackNameDuplicates";
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = "ros-cdk:enableDiffNoFail";
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = "ros-cdk:newStyleStackSynthesis";
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: "true",
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: "true",
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmVhdHVyZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmZWF0dXJlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsbUZBQW1GO0FBQ25GLHVFQUF1RTtBQUN2RSw2RUFBNkU7QUFDN0UsZ0ZBQWdGO0FBQ2hGLDBFQUEwRTtBQUMxRSw2RUFBNkU7QUFDN0Usd0RBQXdEO0FBQ3hELG1GQUFtRjs7O0FBRW5GOzs7Ozs7Ozs7R0FTRztBQUNVLFFBQUEsb0NBQW9DLEdBQy9DLG1DQUFtQyxDQUFDO0FBRXRDOzs7O0dBSUc7QUFDVSxRQUFBLDJCQUEyQixHQUFHLDBCQUEwQixDQUFDO0FBQ3RFLG9EQUFvRDtBQUN2QyxRQUFBLG1CQUFtQixHQUFHLG1DQUEyQixDQUFDO0FBRS9EOztHQUVHO0FBQ1UsUUFBQSxpQ0FBaUMsR0FDNUMsZ0NBQWdDLENBQUM7QUFFbkM7Ozs7Ozs7Ozs7OztHQVlHO0FBQ1UsUUFBQSxZQUFZLEdBQUc7SUFDMUIsQ0FBQyw0Q0FBb0MsQ0FBQyxFQUFFLE1BQU07SUFDOUMsQ0FBQyxtQ0FBMkIsQ0FBQyxFQUFFLE1BQU07Q0FJdEMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXHJcbi8vIFRoaXMgZmlsZSBkZWZpbmVzIGNvbnRleHQga2V5cyB0aGF0IGVuYWJsZSBjZXJ0YWluIGZlYXR1cmVzIHRoYXQgYXJlXHJcbi8vIGltcGxlbWVudGVkIGJlaGluZCBhIGZsYWcgaW4gb3JkZXIgdG8gcHJlc2VydmUgYmFja3dhcmRzIGNvbXBhdGliaWxpdHkgZm9yXHJcbi8vIGV4aXN0aW5nIGFwcHMuIFdoZW4gYSBuZXcgYXBwIGlzIGluaXRpYWxpemVkIHRocm91Z2ggYGNkayBpbml0YCwgdGhlIENMSSB3aWxsXHJcbi8vIGF1dG9tYXRpY2FsbHkgYWRkIGVuYWJsZSB0aGVzZSBmZWF0dXJlcyBieSBhZGRpbmcgdGhlbSB0byB0aGUgZ2VuZXJhdGVkXHJcbi8vIGBjZGsuanNvbmAgZmlsZS4gSW4gdGhlIG5leHQgbWFqb3IgcmVsZWFzZSBvZiB0aGUgQ0RLLCB0aGVzZSBmZWF0dXJlIGZsYWdzXHJcbi8vIHdpbGwgYmUgcmVtb3ZlZCBhbmQgd2lsbCBiZWNvbWUgdGhlIGRlZmF1bHQgYmVoYXZpb3IuXHJcbi8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXHJcblxyXG4vKipcclxuICogSWYgdGhpcyBpcyBzZXQsIG11bHRpcGxlIHN0YWNrcyBjYW4gdXNlIHRoZSBzYW1lIHN0YWNrIG5hbWUgKGUuZy4gZGVwbG95ZWQgdG9cclxuICogZGlmZmVyZW50IGVudmlyb25tZW50cykuIFRoaXMgbWVhbnMgdGhhdCB0aGUgbmFtZSBvZiB0aGUgc3ludGhlc2l6ZWQgdGVtcGxhdGVcclxuICogZmlsZSB3aWxsIGJlIGJhc2VkIG9uIHRoZSBjb25zdHJ1Y3QgcGF0aCBhbmQgbm90IG9uIHRoZSBkZWZpbmVkIGBzdGFja05hbWVgXHJcbiAqIG9mIHRoZSBzdGFjay5cclxuICpcclxuICogVGhpcyBpcyBhIFwiZnV0dXJlIGZsYWdcIjogdGhlIGZlYXR1cmUgaXMgZGlzYWJsZWQgYnkgZGVmYXVsdCBmb3IgYmFja3dhcmRzXHJcbiAqIGNvbXBhdGliaWxpdHksIGJ1dCBuZXcgcHJvamVjdHMgY3JlYXRlZCB1c2luZyBgY2RrIGluaXRgIHdpbGwgaGF2ZSB0aGlzXHJcbiAqIGVuYWJsZWQgdGhyb3VnaCB0aGUgZ2VuZXJhdGVkIGBjZGsuanNvbmAuXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgRU5BQkxFX1NUQUNLX05BTUVfRFVQTElDQVRFU19DT05URVhUID1cclxuICBcInJvcy1jZGs6ZW5hYmxlU3RhY2tOYW1lRHVwbGljYXRlc1wiO1xyXG5cclxuLyoqXHJcbiAqIElGIHRoaXMgaXMgc2V0LCBgY2RrIGRpZmZgIHdpbGwgYWx3YXlzIGV4aXQgd2l0aCAwLlxyXG4gKlxyXG4gKiBVc2UgYGNkayBkaWZmIC0tZmFpbGAgdG8gZXhpdCB3aXRoIDEgaWYgdGhlcmUncyBhIGRpZmYuXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgRU5BQkxFX0RJRkZfTk9fRkFJTF9DT05URVhUID0gXCJyb3MtY2RrOmVuYWJsZURpZmZOb0ZhaWxcIjtcclxuLyoqIEBkZXByZWNhdGVkIHVzZSBgRU5BQkxFX0RJRkZfTk9fRkFJTF9DT05URVhUYCAqL1xyXG5leHBvcnQgY29uc3QgRU5BQkxFX0RJRkZfTk9fRkFJTCA9IEVOQUJMRV9ESUZGX05PX0ZBSUxfQ09OVEVYVDtcclxuXHJcbi8qKlxyXG4gKiBTd2l0Y2ggdG8gbmV3IHN0YWNrIHN5bnRoZXNpcyBtZXRob2Qgd2hpY2ggZW5hYmxlIENJL0NEXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgTkVXX1NUWUxFX1NUQUNLX1NZTlRIRVNJU19DT05URVhUID1cclxuICBcInJvcy1jZGs6bmV3U3R5bGVTdGFja1N5bnRoZXNpc1wiO1xyXG5cclxuLyoqXHJcbiAqIFRoaXMgbWFwIGluY2x1ZGVzIGNvbnRleHQga2V5cyBhbmQgdmFsdWVzIGZvciBmZWF0dXJlIGZsYWdzIHRoYXQgZW5hYmxlXHJcbiAqIGNhcGFiaWxpdGllcyBcImZyb20gdGhlIGZ1dHVyZVwiLCB3aGljaCB3ZSBjb3VsZCBub3QgaW50cm9kdWNlIGFzIHRoZSBkZWZhdWx0XHJcbiAqIGJlaGF2aW9yIGR1ZSB0byBiYWNrd2FyZHMgY29tcGF0aWJpbGl0eSBmb3IgZXhpc3RpbmcgcHJvamVjdHMuXHJcbiAqXHJcbiAqIE5ldyBwcm9qZWN0cyBnZW5lcmF0ZWQgdGhyb3VnaCBgY2RrIGluaXRgIHdpbGwgaW5jbHVkZSB0aGVzZSBmbGFncyBpbiB0aGVpclxyXG4gKiBnZW5lcmF0ZWQgYGNkay5qc29uYCBmaWxlLlxyXG4gKlxyXG4gKiBXaGVuIHdlIHJlbGVhc2UgdGhlIG5leHQgbWFqb3IgdmVyc2lvbiBvZiB0aGUgQ0RLLCB3ZSB3aWxsIGZsaXAgdGhlIGxvZ2ljIG9mXHJcbiAqIHRoZXNlIGZlYXR1cmVzIGFuZCBjbGVhbiB1cCB0aGUgYGNkay5qc29uYCBnZW5lcmF0ZWQgYnkgYGNkayBpbml0YC5cclxuICpcclxuICogVGVzdHMgbXVzdCBjb3ZlciB0aGUgZGVmYXVsdCAoZGlzYWJsZWQpIGNhc2UgYW5kIHRoZSBmdXR1cmUgKGVuYWJsZWQpIGNhc2UuXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgRlVUVVJFX0ZMQUdTID0ge1xyXG4gIFtFTkFCTEVfU1RBQ0tfTkFNRV9EVVBMSUNBVEVTX0NPTlRFWFRdOiBcInRydWVcIixcclxuICBbRU5BQkxFX0RJRkZfTk9fRkFJTF9DT05URVhUXTogXCJ0cnVlXCIsXHJcblxyXG4gIC8vIFdlIHdpbGwgYWR2ZXJ0aXNlIHRoaXMgZmxhZyB3aGVuIHRoZSBmZWF0dXJlIGlzIGNvbXBsZXRlXHJcbiAgLy8gW05FV19TVFlMRV9TVEFDS19TWU5USEVTSVNdOiAndHJ1ZScsXHJcbn07XHJcbiJdfQ==