"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStackArtifact = void 0;
const fs = require("fs");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
class RosStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        const properties = (this.manifest.properties ||
            {});
        if (!properties.templateFile) {
            throw new Error('Invalid ROS stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters || {};
        this.stackName = properties.stackName || artifactId;
        this.displayName =
            this.stackName === artifactId
                ? this.stackName
                : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * The ROS template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(path.join(this.assembly.directory, this.templateFile), "utf-8"));
        }
        return this._template;
    }
}
exports.RosStackArtifact = RosStackArtifact;
//# sourceMappingURL=data:application/json;base64,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