"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties ||
            {});
        this.directoryName = properties.directoryName;
        this.displayName = (_a = properties.displayName) !== null && _a !== void 0 ? _a : name;
    }
    /**
     * Full path to the nested assembly directory
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
    /**
     * The nested Assembly
     */
    get nestedAssembly() {
        if (!this._nestedAssembly) {
            this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
//# sourceMappingURL=data:application/json;base64,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