"""
# `@alicloud/ros-cdk-cxapi`

> TODO: description

## Usage

```
const rosCxapi = require('@alicloud/ros-cdk-cxapi');

// TODO: DEMONSTRATE API
```
"""
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import ros_cdk_assembly_schema


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.AliyunRosStackProperties",
    jsii_struct_bases=[],
    name_mapping={
        "template_file": "templateFile",
        "parameters": "parameters",
        "stack_name": "stackName",
    },
)
class AliyunRosStackProperties:
    def __init__(
        self,
        *,
        template_file: builtins.str,
        parameters: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        stack_name: typing.Optional[builtins.str] = None,
    ) -> None:
        """Artifact properties for ROS stacks.

        :param template_file: A file relative to the assembly root which contains the ROS template for this stack.
        :param parameters: Values for ROS stack parameters that should be passed when the stack is deployed.
        :param stack_name: The name to use for the ROS stack. Default: - name derived from artifact ID
        """
        self._values: typing.Dict[str, typing.Any] = {
            "template_file": template_file,
        }
        if parameters is not None:
            self._values["parameters"] = parameters
        if stack_name is not None:
            self._values["stack_name"] = stack_name

    @builtins.property
    def template_file(self) -> builtins.str:
        """A file relative to the assembly root which contains the ROS template for this stack."""
        result = self._values.get("template_file")
        assert result is not None, "Required property 'template_file' is missing"
        return result

    @builtins.property
    def parameters(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        """Values for ROS stack parameters that should be passed when the stack is deployed."""
        result = self._values.get("parameters")
        return result

    @builtins.property
    def stack_name(self) -> typing.Optional[builtins.str]:
        """The name to use for the ROS stack.

        :default: - name derived from artifact ID
        """
        result = self._values.get("stack_name")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AliyunRosStackProperties(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.AssemblyBuildOptions",
    jsii_struct_bases=[],
    name_mapping={"runtime_info": "runtimeInfo"},
)
class AssemblyBuildOptions:
    def __init__(self, *, runtime_info: typing.Optional["RuntimeInfo"] = None) -> None:
        """
        :param runtime_info: Include the specified runtime information (module versions) in manifest. Default: - if this option is not specified, runtime info will not be included
        """
        if isinstance(runtime_info, dict):
            runtime_info = RuntimeInfo(**runtime_info)
        self._values: typing.Dict[str, typing.Any] = {}
        if runtime_info is not None:
            self._values["runtime_info"] = runtime_info

    @builtins.property
    def runtime_info(self) -> typing.Optional["RuntimeInfo"]:
        """Include the specified runtime information (module versions) in manifest.

        :default: - if this option is not specified, runtime info will not be included
        """
        result = self._values.get("runtime_info")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AssemblyBuildOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CloudArtifact(
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.CloudArtifact",
):
    """Represents an artifact within a cloud assembly."""

    def __init__(
        self,
        assembly: "CloudAssembly",
        id: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> None:
        """
        :param assembly: -
        :param id: -
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.
        """
        manifest = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        jsii.create(CloudArtifact, self, [assembly, id, manifest])

    @jsii.member(jsii_name="fromManifest")
    @builtins.classmethod
    def from_manifest(
        cls,
        assembly: "CloudAssembly",
        id: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> typing.Optional["CloudArtifact"]:
        """Returns a subclass of ``CloudArtifact`` based on the artifact type defined in the artifact manifest.

        :param assembly: The cloud assembly from which to load the artifact.
        :param id: The artifact ID.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.

        :return: the ``CloudArtifact`` that matches the artifact type or ``undefined`` if it's an artifact type that is unrecognized by this module.
        """
        artifact = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        return jsii.sinvoke(cls, "fromManifest", [assembly, id, artifact])

    @jsii.member(jsii_name="findMetadataByType")
    def find_metadata_by_type(
        self,
        type: builtins.str,
    ) -> typing.List["MetadataEntryResult"]:
        """
        :param type: -

        :return: all the metadata entries of a specific type in this artifact.
        """
        return jsii.invoke(self, "findMetadataByType", [type])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="assembly")
    def assembly(self) -> "CloudAssembly":
        return jsii.get(self, "assembly")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return jsii.get(self, "id")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> ros_cdk_assembly_schema.ArtifactManifest:
        """The artifact's manifest."""
        return jsii.get(self, "manifest")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="messages")
    def messages(self) -> typing.List["SynthesisMessage"]:
        """The set of messages extracted from the artifact's metadata."""
        return jsii.get(self, "messages")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="dependencies")
    def dependencies(self) -> typing.Optional[typing.List["CloudArtifact"]]:
        """Returns all the artifacts that this artifact depends on."""
        return jsii.get(self, "dependencies")


class CloudAssembly(
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.CloudAssembly",
):
    """Represents a deployable cloud application."""

    def __init__(self, directory: builtins.str) -> None:
        """Reads a cloud assembly from the specified directory.

        :param directory: The root directory of the assembly.
        """
        jsii.create(CloudAssembly, self, [directory])

    @jsii.member(jsii_name="getNestedAssembly")
    def get_nested_assembly(self, artifact_id: builtins.str) -> "CloudAssembly":
        """Returns a nested assembly.

        :param artifact_id: The artifact ID of the nested assembly.
        """
        return jsii.invoke(self, "getNestedAssembly", [artifact_id])

    @jsii.member(jsii_name="getNestedAssemblyArtifact")
    def get_nested_assembly_artifact(
        self,
        artifact_id: builtins.str,
    ) -> "NestedCloudAssemblyArtifact":
        """Returns a nested assembly artifact.

        :param artifact_id: The artifact ID of the nested assembly.
        """
        return jsii.invoke(self, "getNestedAssemblyArtifact", [artifact_id])

    @jsii.member(jsii_name="getStack")
    def get_stack(self, stack_name: builtins.str) -> "RosStackArtifact":
        """(deprecated) Returns a ROS stack artifact by name from this assembly.

        :param stack_name: -

        :deprecated: renamed to ``getStackByName`` (or ``getStackArtifact(id)``)

        :stability: deprecated
        """
        return jsii.invoke(self, "getStack", [stack_name])

    @jsii.member(jsii_name="getStackArtifact")
    def get_stack_artifact(self, artifact_id: builtins.str) -> "RosStackArtifact":
        """Returns a ROS stack artifact from this assembly.

        :param artifact_id: the artifact id of the stack (can be obtained through ``stack.artifactId``).

        :return: a ``RosStackArtifact`` object.

        :throws: if there is no stack artifact with that id
        """
        return jsii.invoke(self, "getStackArtifact", [artifact_id])

    @jsii.member(jsii_name="getStackByName")
    def get_stack_by_name(self, stack_name: builtins.str) -> "RosStackArtifact":
        """Returns a ROS stack artifact from this assembly.

        Will only search the current assembly.

        :param stack_name: the name of the ROS stack.

        :return: a ``RosStackArtifact`` object.

        :throws:

        if there is more than one stack with the same stack name. You can
        use ``getStackArtifact(stack.artifactId)`` instead.
        """
        return jsii.invoke(self, "getStackByName", [stack_name])

    @jsii.member(jsii_name="tree")
    def tree(self) -> typing.Optional["TreeCloudArtifact"]:
        """Returns the tree metadata artifact from this assembly.

        :return: a ``TreeCloudArtifact`` object if there is one defined in the manifest, ``undefined`` otherwise.

        :throws: if there is no metadata artifact by that name
        """
        return jsii.invoke(self, "tree", [])

    @jsii.member(jsii_name="tryGetArtifact")
    def try_get_artifact(self, id: builtins.str) -> typing.Optional[CloudArtifact]:
        """Attempts to find an artifact with a specific identity.

        :param id: The artifact ID.

        :return: A ``CloudArtifact`` object or ``undefined`` if the artifact does not exist in this assembly.
        """
        return jsii.invoke(self, "tryGetArtifact", [id])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="artifacts")
    def artifacts(self) -> typing.List[CloudArtifact]:
        """All artifacts included in this assembly."""
        return jsii.get(self, "artifacts")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="directory")
    def directory(self) -> builtins.str:
        """The root directory of the cloud assembly."""
        return jsii.get(self, "directory")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> ros_cdk_assembly_schema.AssemblyManifest:
        """The raw assembly manifest."""
        return jsii.get(self, "manifest")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="runtime")
    def runtime(self) -> ros_cdk_assembly_schema.RuntimeInfo:
        """Runtime information such as module versions used to synthesize this assembly."""
        return jsii.get(self, "runtime")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stacks")
    def stacks(self) -> typing.List["RosStackArtifact"]:
        """
        :return: all the ROS stack artifacts that are included in this assembly.
        """
        return jsii.get(self, "stacks")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        """The schema version of the assembly manifest."""
        return jsii.get(self, "version")


class CloudAssemblyBuilder(
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.CloudAssemblyBuilder",
):
    """Can be used to build a cloud assembly."""

    def __init__(self, outdir: typing.Optional[builtins.str] = None) -> None:
        """Initializes a cloud assembly builder.

        :param outdir: The output directory, uses temporary directory if undefined.
        """
        jsii.create(CloudAssemblyBuilder, self, [outdir])

    @jsii.member(jsii_name="addArtifact")
    def add_artifact(
        self,
        id: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> None:
        """Adds an artifact into the cloud assembly.

        :param id: The ID of the artifact.
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.
        """
        manifest = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        return jsii.invoke(self, "addArtifact", [id, manifest])

    @jsii.member(jsii_name="addMissing")
    def add_missing(
        self,
        *,
        key: builtins.str,
        props: typing.Union[ros_cdk_assembly_schema.AmiContextQuery, ros_cdk_assembly_schema.AvailabilityZonesContextQuery, ros_cdk_assembly_schema.HostedZoneContextQuery, ros_cdk_assembly_schema.SSMParameterContextQuery, ros_cdk_assembly_schema.VpcContextQuery, ros_cdk_assembly_schema.EndpointServiceAvailabilityZonesContextQuery],
        provider: ros_cdk_assembly_schema.ContextProvider,
    ) -> None:
        """Reports that some context is missing in order for this cloud assembly to be fully synthesized.

        :param key: The missing context key.
        :param props: A set of provider-specific options.
        :param provider: The provider from which we expect this context key to be obtained.
        """
        missing = ros_cdk_assembly_schema.MissingContext(
            key=key, props=props, provider=provider
        )

        return jsii.invoke(self, "addMissing", [missing])

    @jsii.member(jsii_name="buildAssembly")
    def build_assembly(
        self,
        *,
        runtime_info: typing.Optional["RuntimeInfo"] = None,
    ) -> CloudAssembly:
        """Finalizes the cloud assembly into the output directory returns a
``CloudAssembly`` object that can be used to inspect the assembly.

        :param runtime_info: Include the specified runtime information (module versions) in manifest. Default: - if this option is not specified, runtime info will not be included
        """
        options = AssemblyBuildOptions(runtime_info=runtime_info)

        return jsii.invoke(self, "buildAssembly", [options])

    @jsii.member(jsii_name="createNestedAssembly")
    def create_nested_assembly(
        self,
        artifact_id: builtins.str,
        display_name: builtins.str,
    ) -> "CloudAssemblyBuilder":
        """Creates a nested cloud assembly.

        :param artifact_id: -
        :param display_name: -
        """
        return jsii.invoke(self, "createNestedAssembly", [artifact_id, display_name])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> builtins.str:
        """The root directory of the resulting cloud assembly."""
        return jsii.get(self, "outdir")


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.MetadataEntry",
    jsii_struct_bases=[ros_cdk_assembly_schema.MetadataEntry],
    name_mapping={"type": "type", "data": "data", "trace": "trace"},
)
class MetadataEntry(ros_cdk_assembly_schema.MetadataEntry):
    def __init__(
        self,
        *,
        type: builtins.str,
        data: typing.Optional[typing.Union[builtins.str, typing.List[ros_cdk_assembly_schema.Tag]]] = None,
        trace: typing.Optional[typing.List[builtins.str]] = None,
    ) -> None:
        """(deprecated) Backwards compatibility for when ``MetadataEntry``
was defined here.

        This is necessary because its used as an input in the stable

        :param type: The type of the metadata entry.
        :param data: The data. Default: - no data.
        :param trace: A stack trace for when the entry was created. Default: - no trace.

        :deprecated: moved to package 'ros-assembly-schema'

        :see: core.ConstructNode.metadata
        :stability: deprecated
        :alicloud: /ros-cdk-core library.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
        }
        if data is not None:
            self._values["data"] = data
        if trace is not None:
            self._values["trace"] = trace

    @builtins.property
    def type(self) -> builtins.str:
        """The type of the metadata entry."""
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def data(
        self,
    ) -> typing.Optional[typing.Union[builtins.str, typing.List[ros_cdk_assembly_schema.Tag]]]:
        """The data.

        :default: - no data.
        """
        result = self._values.get("data")
        return result

    @builtins.property
    def trace(self) -> typing.Optional[typing.List[builtins.str]]:
        """A stack trace for when the entry was created.

        :default: - no trace.
        """
        result = self._values.get("trace")
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetadataEntry(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.MetadataEntryResult",
    jsii_struct_bases=[ros_cdk_assembly_schema.MetadataEntry],
    name_mapping={"type": "type", "data": "data", "trace": "trace", "path": "path"},
)
class MetadataEntryResult(ros_cdk_assembly_schema.MetadataEntry):
    def __init__(
        self,
        *,
        type: builtins.str,
        data: typing.Optional[typing.Union[builtins.str, typing.List[ros_cdk_assembly_schema.Tag]]] = None,
        trace: typing.Optional[typing.List[builtins.str]] = None,
        path: builtins.str,
    ) -> None:
        """
        :param type: The type of the metadata entry.
        :param data: The data. Default: - no data.
        :param trace: A stack trace for when the entry was created. Default: - no trace.
        :param path: The path in which this entry was defined.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "type": type,
            "path": path,
        }
        if data is not None:
            self._values["data"] = data
        if trace is not None:
            self._values["trace"] = trace

    @builtins.property
    def type(self) -> builtins.str:
        """The type of the metadata entry."""
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return result

    @builtins.property
    def data(
        self,
    ) -> typing.Optional[typing.Union[builtins.str, typing.List[ros_cdk_assembly_schema.Tag]]]:
        """The data.

        :default: - no data.
        """
        result = self._values.get("data")
        return result

    @builtins.property
    def trace(self) -> typing.Optional[typing.List[builtins.str]]:
        """A stack trace for when the entry was created.

        :default: - no trace.
        """
        result = self._values.get("trace")
        return result

    @builtins.property
    def path(self) -> builtins.str:
        """The path in which this entry was defined."""
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetadataEntryResult(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.MissingContext",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "props": "props", "provider": "provider"},
)
class MissingContext:
    def __init__(
        self,
        *,
        key: builtins.str,
        props: typing.Mapping[builtins.str, typing.Any],
        provider: builtins.str,
    ) -> None:
        """(deprecated) Backwards compatibility for when ``MissingContext``
was defined here.

        This is necessary because its used as an input in the stable

        :param key: (deprecated) The missing context key.
        :param props: (deprecated) A set of provider-specific options. (This is the old untyped definition, which is necessary for backwards compatibility. See cxschema for a type definition.)
        :param provider: (deprecated) The provider from which we expect this context key to be obtained. (This is the old untyped definition, which is necessary for backwards compatibility. See cxschema for a type definition.)

        :deprecated: moved to package 'ros-assembly-schema'

        :see: core.Stack.reportMissingContext
        :stability: deprecated
        :alicloud: /ros-cdk-core library.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "key": key,
            "props": props,
            "provider": provider,
        }

    @builtins.property
    def key(self) -> builtins.str:
        """(deprecated) The missing context key.

        :stability: deprecated
        """
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return result

    @builtins.property
    def props(self) -> typing.Mapping[builtins.str, typing.Any]:
        """(deprecated) A set of provider-specific options.

        (This is the old untyped definition, which is necessary for backwards compatibility.
        See cxschema for a type definition.)

        :stability: deprecated
        """
        result = self._values.get("props")
        assert result is not None, "Required property 'props' is missing"
        return result

    @builtins.property
    def provider(self) -> builtins.str:
        """(deprecated) The provider from which we expect this context key to be obtained.

        (This is the old untyped definition, which is necessary for backwards compatibility.
        See cxschema for a type definition.)

        :stability: deprecated
        """
        result = self._values.get("provider")
        assert result is not None, "Required property 'provider' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MissingContext(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NestedCloudAssemblyArtifact(
    CloudArtifact,
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.NestedCloudAssemblyArtifact",
):
    """Asset manifest is a description of a set of assets which need to be built and published."""

    def __init__(
        self,
        assembly: CloudAssembly,
        name: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> None:
        """
        :param assembly: -
        :param name: -
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.
        """
        artifact = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        jsii.create(NestedCloudAssemblyArtifact, self, [assembly, name, artifact])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="directoryName")
    def directory_name(self) -> builtins.str:
        """The relative directory name of the asset manifest."""
        return jsii.get(self, "directoryName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        """Display name."""
        return jsii.get(self, "displayName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="fullPath")
    def full_path(self) -> builtins.str:
        """Full path to the nested assembly directory."""
        return jsii.get(self, "fullPath")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="nestedAssembly")
    def nested_assembly(self) -> CloudAssembly:
        """The nested Assembly."""
        return jsii.get(self, "nestedAssembly")


class RosStackArtifact(
    CloudArtifact,
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.RosStackArtifact",
):
    def __init__(
        self,
        assembly: CloudAssembly,
        artifact_id: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> None:
        """
        :param assembly: -
        :param artifact_id: -
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.
        """
        artifact = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        jsii.create(RosStackArtifact, self, [assembly, artifact_id, artifact])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> builtins.str:
        """A string that represents this stack.

        Should only be used in user interfaces.
        If the stackName and artifactId are the same, it will just return that. Otherwise,
        it will return something like " ()"
        """
        return jsii.get(self, "displayName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        """(deprecated) The physical name of this stack.

        :deprecated: renamed to ``stackName``

        :stability: deprecated
        """
        return jsii.get(self, "name")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="originalName")
    def original_name(self) -> builtins.str:
        """The original name as defined in the CDK app."""
        return jsii.get(self, "originalName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="parameters")
    def parameters(self) -> typing.Mapping[builtins.str, builtins.str]:
        """ROS parameters to pass to the stack."""
        return jsii.get(self, "parameters")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="stackName")
    def stack_name(self) -> builtins.str:
        """The physical name of this stack."""
        return jsii.get(self, "stackName")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="template")
    def template(self) -> typing.Any:
        """The ROS template for this stack."""
        return jsii.get(self, "template")

    @builtins.property # type: ignore
    @jsii.member(jsii_name="templateFile")
    def template_file(self) -> builtins.str:
        """The file name of the template."""
        return jsii.get(self, "templateFile")


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.RuntimeInfo",
    jsii_struct_bases=[ros_cdk_assembly_schema.RuntimeInfo],
    name_mapping={"libraries": "libraries"},
)
class RuntimeInfo(ros_cdk_assembly_schema.RuntimeInfo):
    def __init__(
        self,
        *,
        libraries: typing.Mapping[builtins.str, builtins.str],
    ) -> None:
        """(deprecated) Backwards compatibility for when ``RuntimeInfo``
was defined here.

        This is necessary because its used as an input in the stable

        :param libraries: The list of libraries loaded in the application, associated with their versions.

        :deprecated: moved to package 'ros-assembly-schema'

        :see: core.ConstructNode.synth
        :stability: deprecated
        :alicloud: /ros-cdk-core library.
        """
        self._values: typing.Dict[str, typing.Any] = {
            "libraries": libraries,
        }

    @builtins.property
    def libraries(self) -> typing.Mapping[builtins.str, builtins.str]:
        """The list of libraries loaded in the application, associated with their versions."""
        result = self._values.get("libraries")
        assert result is not None, "Required property 'libraries' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RuntimeInfo(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@alicloud/ros-cdk-cxapi.SynthesisMessage",
    jsii_struct_bases=[],
    name_mapping={"entry": "entry", "id": "id", "level": "level"},
)
class SynthesisMessage:
    def __init__(
        self,
        *,
        entry: ros_cdk_assembly_schema.MetadataEntry,
        id: builtins.str,
        level: "SynthesisMessageLevel",
    ) -> None:
        """
        :param entry: -
        :param id: -
        :param level: -
        """
        if isinstance(entry, dict):
            entry = ros_cdk_assembly_schema.MetadataEntry(**entry)
        self._values: typing.Dict[str, typing.Any] = {
            "entry": entry,
            "id": id,
            "level": level,
        }

    @builtins.property
    def entry(self) -> ros_cdk_assembly_schema.MetadataEntry:
        result = self._values.get("entry")
        assert result is not None, "Required property 'entry' is missing"
        return result

    @builtins.property
    def id(self) -> builtins.str:
        result = self._values.get("id")
        assert result is not None, "Required property 'id' is missing"
        return result

    @builtins.property
    def level(self) -> "SynthesisMessageLevel":
        result = self._values.get("level")
        assert result is not None, "Required property 'level' is missing"
        return result

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SynthesisMessage(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="@alicloud/ros-cdk-cxapi.SynthesisMessageLevel")
class SynthesisMessageLevel(enum.Enum):
    INFO = "INFO"
    WARNING = "WARNING"
    ERROR = "ERROR"


class TreeCloudArtifact(
    CloudArtifact,
    metaclass=jsii.JSIIMeta,
    jsii_type="@alicloud/ros-cdk-cxapi.TreeCloudArtifact",
):
    def __init__(
        self,
        assembly: CloudAssembly,
        name: builtins.str,
        *,
        type: ros_cdk_assembly_schema.ArtifactType,
        dependencies: typing.Optional[typing.List[builtins.str]] = None,
        metadata: typing.Optional[typing.Mapping[builtins.str, typing.List[ros_cdk_assembly_schema.MetadataEntry]]] = None,
        properties: typing.Optional[typing.Union[ros_cdk_assembly_schema.AliyunRosStackProperties, ros_cdk_assembly_schema.TreeArtifactProperties, ros_cdk_assembly_schema.NestedCloudAssemblyProperties]] = None,
    ) -> None:
        """
        :param assembly: -
        :param name: -
        :param type: The type of artifact.
        :param dependencies: IDs of artifacts that must be deployed before this artifact. Default: - no dependencies.
        :param metadata: Associated metadata. Default: - no metadata.
        :param properties: The set of properties for this artifact (depends on type). Default: - no properties.
        """
        artifact = ros_cdk_assembly_schema.ArtifactManifest(
            type=type,
            dependencies=dependencies,
            metadata=metadata,
            properties=properties,
        )

        jsii.create(TreeCloudArtifact, self, [assembly, name, artifact])

    @builtins.property # type: ignore
    @jsii.member(jsii_name="file")
    def file(self) -> builtins.str:
        return jsii.get(self, "file")


__all__ = [
    "AliyunRosStackProperties",
    "AssemblyBuildOptions",
    "CloudArtifact",
    "CloudAssembly",
    "CloudAssemblyBuilder",
    "MetadataEntry",
    "MetadataEntryResult",
    "MissingContext",
    "NestedCloudAssemblyArtifact",
    "RosStackArtifact",
    "RuntimeInfo",
    "SynthesisMessage",
    "SynthesisMessageLevel",
    "TreeCloudArtifact",
]

publication.publish()
