# Introduction 
Fast `primes` generator which caches previous results across instances.\
You usually don't need as many primes as the worst-case - eg for the included `lcm` (lowest common multiplier) function.

Also provides a very fast `primesieve` if you wish to pre-calculate a large number of primes.

# Getting Started
Installation: `pip install primegenerator`

## Main usage:
```python
from primegenerator import primes
primenums = primes()
for prime in primenums:
    ... #do something
    if ... #beware this is an infinite generator!
        break
```

## Preseed - if you know you need all primes up to n:
```python
from primegenerator import primes
n = 100 #somebignumber
primenums = primes.preseed(n)
for prime in primenums:
    ... #do something
    if ... #beware this is still an infinite generator and will keep going past the seed point!
        break
```

## Lowest common multiplier:
```python
from primegenerator import lcm
numbers = [2,3,4]
assert lcm(numbers) == 12
```

## Sieve:
```python
from primegenerator import primesieve
listofprimes = primesieve(maxprime)
```

# Build and Test
Tests are written for pytest in `/tests/test_*.py`\
`pip -r tests/requirements.txt` for additional imports required for some tests.\
Tests are available on the ADO repository (see link below)

`/dev` contains some useful stuff for debugging, profiling and further development and is only available on the ADO repository (see link below)

# Contribute
Code repository (ADO): https://dev.azure.com/MusicalNinjas/MikesMath/_git/primes \
Homepage: https://dev.azure.com/MusicalNinjas/MikesMath

# Coming soon...
```python
assert 31 in primenums
```
```python
assert primenums[3] == 5
```
