# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-03-18 18:51
from __future__ import unicode_literals

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import minimal_log_host.utils


class Migration(migrations.Migration):

    dependencies = [
        ('minimal_log_host', '0001_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='minimallogentry',
            name='description',
            field=models.TextField(help_text='Describe the problem, change, situation or event.'),
        ),
        migrations.AlterField(
            model_name='minimallogentry',
            name='key',
            field=models.ForeignKey(help_text='Key used to authenticate this log entry.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='minimal_log_host.MinimalLogKey'),
        ),
        migrations.AlterField(
            model_name='minimallogentry',
            name='solver',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='minimallogentry',
            name='status',
            field=models.CharField(choices=[('good', 'success'), ('info', 'info'), ('warn', 'warning'), ('error', 'error')], help_text='What kind of situation is this?', max_length=8),
        ),
        migrations.AlterField(
            model_name='minimallogkey',
            name='active',
            field=models.BooleanField(default=True, help_text='Turn this off to disable the key.'),
        ),
        migrations.AlterField(
            model_name='minimallogkey',
            name='description',
            field=models.CharField(help_text="Describe the service uses this key. It's best to generate a new key for each service so that you can easily revoke individual ones.", max_length=128, validators=[django.core.validators.MinLengthValidator(3)]),
        ),
        migrations.AlterField(
            model_name='minimallogkey',
            name='value',
            field=models.CharField(default=minimal_log_host.utils.generate_key, help_text='Secret key used as authentication token (keep it secret!).', max_length=64, unique=True),
        ),
    ]
