# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-02-01 23:51
from __future__ import unicode_literals

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import minimal_log_host.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='MinimalLogEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(help_text=b'Describe the problem, change, situation or event.')),
                ('status', models.CharField(choices=[(b'good', b'success'), (b'info', b'info'), (b'warn', b'warning'), (b'error', b'error')], help_text=b'What kind of situation is this?', max_length=8)),
                ('added', models.DateTimeField(auto_now_add=True)),
                ('from_ip', models.CharField(max_length=16, null=True)),
                ('resolved', models.DateTimeField(blank=True, default=None, null=True)),
            ],
            options={
                'verbose_name': 'entry',
                'verbose_name_plural': 'entries',
            },
        ),
        migrations.CreateModel(
            name='MinimalLogKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(help_text=b"Describe the service uses this key. It's best to generate a new key for each service so that you can easily revoke individual ones.", max_length=128, validators=[django.core.validators.MinLengthValidator(3)])),
                ('value', models.CharField(default=minimal_log_host.utils.generate_key, help_text=b'Secret key used as authentication token (keep it secret!).', max_length=64, unique=True)),
                ('active', models.BooleanField(default=True, help_text=b'Turn this off to disable the key.')),
                ('added', models.DateTimeField(auto_now_add=True)),
                ('adder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'key',
            },
        ),
        migrations.AddField(
            model_name='minimallogentry',
            name='key',
            field=models.ForeignKey(help_text=b'Key used to authenticate this log entry.', on_delete=django.db.models.deletion.CASCADE, to='minimal_log_host.MinimalLogKey'),
        ),
        migrations.AddField(
            model_name='minimallogentry',
            name='solver',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
