/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import ujson.IncompleteParseException;
import ujson.ParseException;
import upickle.core.Abort;
import upickle.core.AbortException;
import upickle.core.ArrVisitor;
import upickle.core.BufferingCharParser;
import upickle.core.CharBuilder;
import upickle.core.CharBuilder$;
import upickle.core.CharOps$;
import upickle.core.ObjArrVisitor;
import upickle.core.ObjVisitor;
import upickle.core.RenderUtils$;
import upickle.core.Visitor;
import upickle.core.WrapCharArrayCharSeq;

public abstract class CharParser<J>
implements BufferingCharParser {
    private final CharOps$ elemOps;
    private final CharBuilder outputBuilder;
    private char[] upickle$core$BufferingCharParser$$buffer;
    private int upickle$core$BufferingCharParser$$bufferGrowCount;
    private int upickle$core$BufferingCharParser$$bufferCopyCount;
    private int upickle$core$BufferingCharParser$$firstIdx;
    private int upickle$core$BufferingCharParser$$lastIdx;
    private int upickle$core$BufferingCharParser$$dropped;
    private int upickle$core$BufferingCharParser$$knownEof;

    @Override
    public char getCharUnsafe(int i) {
        return BufferingCharParser.getCharUnsafe$(this, i);
    }

    @Override
    public void growBuffer(int until) {
        BufferingCharParser.growBuffer$(this, until);
    }

    @Override
    public boolean requestUntil(int until) {
        return BufferingCharParser.requestUntil$(this, until);
    }

    @Override
    public void dropBufferUntil(int i) {
        BufferingCharParser.dropBufferUntil$(this, i);
    }

    @Override
    public WrapCharArrayCharSeq unsafeCharSeqForRange(int start, int length) {
        return BufferingCharParser.unsafeCharSeqForRange$(this, start, length);
    }

    @Override
    public void appendCharsToBuilder(CharBuilder elems, int elemsStart, int elemsLength) {
        BufferingCharParser.appendCharsToBuilder$(this, elems, elemsStart, elemsLength);
    }

    @Override
    public char[] upickle$core$BufferingCharParser$$buffer() {
        return this.upickle$core$BufferingCharParser$$buffer;
    }

    @Override
    public void upickle$core$BufferingCharParser$$buffer_$eq(char[] x$1) {
        this.upickle$core$BufferingCharParser$$buffer = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$bufferGrowCount() {
        return this.upickle$core$BufferingCharParser$$bufferGrowCount;
    }

    @Override
    public void upickle$core$BufferingCharParser$$bufferGrowCount_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$bufferGrowCount = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$bufferCopyCount() {
        return this.upickle$core$BufferingCharParser$$bufferCopyCount;
    }

    @Override
    public void upickle$core$BufferingCharParser$$bufferCopyCount_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$bufferCopyCount = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$firstIdx() {
        return this.upickle$core$BufferingCharParser$$firstIdx;
    }

    @Override
    public void upickle$core$BufferingCharParser$$firstIdx_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$firstIdx = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$lastIdx() {
        return this.upickle$core$BufferingCharParser$$lastIdx;
    }

    @Override
    public void upickle$core$BufferingCharParser$$lastIdx_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$lastIdx = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$dropped() {
        return this.upickle$core$BufferingCharParser$$dropped;
    }

    @Override
    public void upickle$core$BufferingCharParser$$dropped_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$dropped = x$1;
    }

    @Override
    public int upickle$core$BufferingCharParser$$knownEof() {
        return this.upickle$core$BufferingCharParser$$knownEof;
    }

    @Override
    public void upickle$core$BufferingCharParser$$knownEof_$eq(int x$1) {
        this.upickle$core$BufferingCharParser$$knownEof = x$1;
    }

    public void requestUntilOrThrow(int i) {
        if (this.requestUntil(i)) {
            throw new IncompleteParseException("exhausted input");
        }
    }

    public char getCharSafe(int i) {
        this.requestUntilOrThrow(i);
        return this.getCharUnsafe(i);
    }

    public boolean atEof(int i) {
        return this.requestUntil(i);
    }

    public abstract void close();

    public final J parse(Visitor<?, J> facade) {
        int i;
        Tuple2<J, Object> tuple2 = this.parseTopLevel(0, facade);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        J value = tuple2._1();
        int i2 = tuple2._2$mcI$sp();
        Tuple2<J, Integer> tuple22 = new Tuple2<J, Integer>(value, BoxesRunTime.boxToInteger(i2));
        Tuple2<J, Integer> tuple23 = tuple22;
        J value2 = tuple23._1();
        int j = i = tuple23._2$mcI$sp();
        block3: while (!this.atEof(j)) {
            char c = this.getCharSafe(j);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++j;
                    continue block3;
                }
            }
            throw this.die(j, "expected whitespace or eof");
        }
        if (!this.atEof(j)) {
            throw this.die(j, "expected eof");
        }
        this.close();
        return value2;
    }

    public Nothing$ die(int i, String msg) {
        CharBuilder out = new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1());
        RenderUtils$.MODULE$.escapeChar(new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1()), out, new Predef.ArrayCharSequence(new char[]{(char)this.elemOps.toInt(this.getCharSafe(i))}), false, true);
        String s = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s got %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{msg, out.makeString()}));
        throw new ParseException(s, i);
    }

    public final int parseNum(int i, ObjArrVisitor<Object, J> ctxt, Visitor<?, J> facade) {
        int j = i;
        char c = this.getCharSafe(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.getCharSafe(++j);
        }
        if (c == '0') {
            c = this.getCharSafe(++j);
        } else {
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                c = this.getCharSafe(++j);
            }
            if (j == j0) {
                throw this.die(i, "expected digit");
            }
        }
        if (c == '.') {
            decIndex = j - i;
            c = this.getCharSafe(++j);
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                c = this.getCharSafe(++j);
            }
            if (j0 == j) {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.getCharSafe(++j)) == '+' || c == '-') {
                c = this.getCharSafe(++j);
            }
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                c = this.getCharSafe(++j);
            }
            if (j0 == j) {
                throw this.die(i, "expected digit");
            }
        }
        ctxt.visitValue(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), i);
        return j;
    }

    public J visitFloat64StringPartsWithWrapper(Visitor<?, J> facade, int decIndex, int expIndex, int i, int j) {
        return facade.visitFloat64StringParts(this.unsafeCharSeqForRange(i, j - i), decIndex, expIndex, i);
    }

    public final Tuple2<J, Object> parseNumTopLevel(int i, Visitor<?, J> facade) {
        int j = i;
        char c = this.getCharSafe(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.getCharSafe(++j);
        }
        if (c == '0') {
            if (this.atEof(++j)) {
                return new Tuple2<J, Integer>(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), BoxesRunTime.boxToInteger(j));
            }
            c = this.getCharSafe(j);
        } else {
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                if (this.atEof(++j)) {
                    return new Tuple2<J, Integer>(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), BoxesRunTime.boxToInteger(j));
                }
                c = this.getCharSafe(j);
            }
            if (j0 == j) {
                throw this.die(i, "expected digit");
            }
        }
        if (c == '.') {
            decIndex = j - i;
            c = this.getCharSafe(++j);
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                if (this.atEof(++j)) {
                    return new Tuple2<J, Integer>(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), BoxesRunTime.boxToInteger(j));
                }
                c = this.getCharSafe(j);
            }
            if (j0 == j) {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.getCharSafe(++j)) == '+' || c == '-') {
                c = this.getCharSafe(++j);
            }
            int j0 = j;
            while (this.elemOps.within('0', c, '9')) {
                if (this.atEof(++j)) {
                    return new Tuple2<J, Integer>(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), BoxesRunTime.boxToInteger(j));
                }
                c = this.getCharSafe(j);
            }
            if (j0 == j) {
                throw this.die(i, "expected digit");
            }
        }
        return new Tuple2<J, Integer>(this.visitFloat64StringPartsWithWrapper(facade, decIndex, expIndex, i, j), BoxesRunTime.boxToInteger(j));
    }

    public final char descape(int i) {
        int x = 0;
        x = x << 4 | RenderUtils$.MODULE$.hex(this.getCharSafe(i + 2));
        x = x << 4 | RenderUtils$.MODULE$.hex(this.getCharSafe(i + 3));
        x = x << 4 | RenderUtils$.MODULE$.hex(this.getCharSafe(i + 4));
        x = x << 4 | RenderUtils$.MODULE$.hex(this.getCharSafe(i + 5));
        return (char)x;
    }

    public final J parseTrue(int i, Visitor<?, J> facade) {
        this.requestUntilOrThrow(i + 3);
        if (this.getCharUnsafe(i + 1) != 'r' || this.getCharUnsafe(i + 2) != 'u' || this.getCharUnsafe(i + 3) != 'e') {
            throw this.die(i, "expected true");
        }
        return facade.visitTrue(i);
    }

    public final J parseFalse(int i, Visitor<?, J> facade) {
        this.requestUntilOrThrow(i + 4);
        if (this.getCharUnsafe(i + 1) != 'a' || this.getCharUnsafe(i + 2) != 'l' || this.getCharUnsafe(i + 3) != 's' || this.getCharUnsafe(i + 4) != 'e') {
            throw this.die(i, "expected false");
        }
        return facade.visitFalse(i);
    }

    public final J parseNull(int i, Visitor<?, J> facade) {
        this.requestUntilOrThrow(i + 3);
        if (this.getCharUnsafe(i + 1) != 'u' || this.getCharUnsafe(i + 2) != 'l' || this.getCharUnsafe(i + 3) != 'l') {
            throw this.die(i, "expected null");
        }
        return facade.visitNull(i);
    }

    public final Tuple2<J, Object> parseTopLevel(int i, Visitor<?, J> facade) {
        Tuple2 tuple2;
        try {
            tuple2 = this.parseTopLevel0(i, facade);
        }
        catch (Throwable x$2) {
            PartialFunction<Throwable, Nothing$> catchExpr$1 = this.reject(i);
            if (catchExpr$1.isDefinedAt(x$2)) {
                tuple2 = (Tuple2)catchExpr$1.apply(x$2);
            }
            throw x$2;
        }
        return tuple2;
    }

    public final Tuple2<J, Object> parseTopLevel0(int i, Visitor<?, J> facade) {
        Tuple2<J, Object> tuple2;
        block11: while (true) {
            char c = this.getCharSafe(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case 'r': {
                    ++i;
                    continue block11;
                }
                case '\n': {
                    ++i;
                    continue block11;
                }
                case '[': {
                    tuple2 = this.parseNested(6, i + 1, facade.visitArray(-1, i), package$.MODULE$.Nil());
                    break block11;
                }
                case '{': {
                    tuple2 = this.parseNested(7, i + 1, facade.visitObject(-1, true, i), package$.MODULE$.Nil());
                    break block11;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    tuple2 = this.parseNumTopLevel(i, facade);
                    break block11;
                }
                case '\"': {
                    tuple2 = this.parseStringTopLevel(i, facade);
                    break block11;
                }
                case 't': {
                    tuple2 = new Tuple2<J, Object>(this.parseTrue(i, facade), BoxesRunTime.boxToInteger(i + 4));
                    break block11;
                }
                case 'f': {
                    tuple2 = new Tuple2<J, Integer>(this.parseFalse(i, facade), BoxesRunTime.boxToInteger(i + 5));
                    break block11;
                }
                case 'n': {
                    tuple2 = new Tuple2<J, Integer>(this.parseNull(i, facade), BoxesRunTime.boxToInteger(i + 4));
                    break block11;
                }
                default: {
                    throw this.die(i, "expected json value");
                }
            }
            break;
        }
        return tuple2;
    }

    public PartialFunction<Throwable, Nothing$> reject(int j) {
        return new Serializable(null, j){
            private final int j$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Abort) {
                    Abort abort = (Abort)A1;
                    throw new AbortException(abort.msg(), this.j$1, -1, -1, abort);
                }
                B1 B1 = function1.apply(x1);
                return B1;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Abort;
                return bl;
            }
            {
                this.j$1 = j$1;
            }
        };
    }

    public final Tuple2<J, Object> parseNested(int state, int i, ObjArrVisitor<?, J> stackHead, List<ObjArrVisitor<?, J>> stackTail) {
        Tuple2 tuple2;
        block47: while (true) {
            char c = this.getCharSafe(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++i;
                    continue block47;
                }
                case '\"': {
                    int n = state;
                    switch (n) {
                        case 2: 
                        case 7: {
                            int nextJ;
                            int n2;
                            try {
                                n2 = this.parseStringKey(i, stackHead);
                            }
                            catch (Throwable x$3) {
                                PartialFunction<Throwable, Nothing$> catchExpr$2 = this.reject(i);
                                if (catchExpr$2.isDefinedAt(x$3)) {
                                    n2 = BoxesRunTime.unboxToInt(catchExpr$2.apply(x$3));
                                }
                                throw x$3;
                            }
                            i = nextJ = n2;
                            state = 3;
                            continue block47;
                        }
                        case 1: 
                        case 6: {
                            int n3;
                            try {
                                n3 = this.parseStringValue(i, stackHead);
                            }
                            catch (Throwable x$4) {
                                PartialFunction<Throwable, Nothing$> catchExpr$3 = this.reject(i);
                                if (catchExpr$3.isDefinedAt(x$4)) {
                                    n3 = BoxesRunTime.unboxToInt(catchExpr$3.apply(x$4));
                                }
                                throw x$4;
                            }
                            int nextJ = n3;
                            int n4 = this.collectionEndFor(stackHead);
                            i = nextJ;
                            state = n4;
                            continue block47;
                        }
                    }
                    throw this.dieWithFailureMessage(i, state);
                }
                case ':': {
                    int n = state;
                    switch (n) {
                        case 3: {
                            ++i;
                            state = 1;
                            continue block47;
                        }
                    }
                    throw this.dieWithFailureMessage(i, state);
                }
                case '[': {
                    ArrVisitor arrVisitor;
                    this.failIfNotData(state, i);
                    try {
                        arrVisitor = stackHead.subVisitor().visitArray(-1, i);
                    }
                    catch (Throwable x$5) {
                        PartialFunction<Throwable, Nothing$> catchExpr$4 = this.reject(i);
                        if (catchExpr$4.isDefinedAt(x$5)) {
                            arrVisitor = (ArrVisitor)catchExpr$4.apply(x$5);
                        }
                        throw x$5;
                    }
                    ArrVisitor ctx = arrVisitor;
                    ArrVisitor arrVisitor2 = stackHead;
                    stackTail = stackTail.$colon$colon(arrVisitor2);
                    stackHead = ctx;
                    ++i;
                    state = 6;
                    continue block47;
                }
                case '{': {
                    ObjVisitor objVisitor;
                    this.failIfNotData(state, i);
                    try {
                        objVisitor = stackHead.subVisitor().visitObject(-1, true, i);
                    }
                    catch (Throwable x$6) {
                        PartialFunction<Throwable, Nothing$> catchExpr$5 = this.reject(i);
                        if (catchExpr$5.isDefinedAt(x$6)) {
                            objVisitor = (ObjVisitor)catchExpr$5.apply(x$6);
                        }
                        throw x$6;
                    }
                    ObjVisitor ctx = objVisitor;
                    ArrVisitor arrVisitor = stackHead;
                    stackTail = stackTail.$colon$colon(arrVisitor);
                    stackHead = ctx;
                    ++i;
                    state = 7;
                    continue block47;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int n;
                    this.failIfNotData(state, i);
                    try {
                        n = this.parseNum(i, stackHead.narrow(), stackHead.subVisitor());
                    }
                    catch (Throwable x$7) {
                        PartialFunction<Throwable, Nothing$> catchExpr$6 = this.reject(i);
                        if (catchExpr$6.isDefinedAt(x$7)) {
                            n = BoxesRunTime.unboxToInt(catchExpr$6.apply(x$7));
                        }
                        throw x$7;
                    }
                    int ctx = n;
                    int n5 = this.collectionEndFor(stackHead);
                    i = ctx;
                    state = n5;
                    continue block47;
                }
                case 't': {
                    BoxedUnit boxedUnit;
                    this.failIfNotData(state, i);
                    try {
                        stackHead.narrow().visitValue(this.parseTrue(i, stackHead.subVisitor()), i);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable x$8) {
                        PartialFunction<Throwable, Nothing$> catchExpr$7 = this.reject(i);
                        if (catchExpr$7.isDefinedAt(x$8)) {
                            boxedUnit = catchExpr$7.apply(x$8);
                        }
                        throw x$8;
                    }
                    int n = this.collectionEndFor(stackHead);
                    i += 4;
                    state = n;
                    continue block47;
                }
                case 'f': {
                    BoxedUnit boxedUnit;
                    this.failIfNotData(state, i);
                    try {
                        stackHead.narrow().visitValue(this.parseFalse(i, stackHead.subVisitor()), i);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable x$9) {
                        PartialFunction<Throwable, Nothing$> catchExpr$8 = this.reject(i);
                        if (catchExpr$8.isDefinedAt(x$9)) {
                            boxedUnit = catchExpr$8.apply(x$9);
                        }
                        throw x$9;
                    }
                    int n = this.collectionEndFor(stackHead);
                    i += 5;
                    state = n;
                    continue block47;
                }
                case 'n': {
                    BoxedUnit boxedUnit;
                    this.failIfNotData(state, i);
                    try {
                        stackHead.narrow().visitValue(this.parseNull(i, stackHead.subVisitor()), i);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable x$10) {
                        PartialFunction<Throwable, Nothing$> catchExpr$9 = this.reject(i);
                        if (catchExpr$9.isDefinedAt(x$10)) {
                            boxedUnit = catchExpr$9.apply(x$10);
                        }
                        throw x$10;
                    }
                    int n = this.collectionEndFor(stackHead);
                    i += 4;
                    state = n;
                    continue block47;
                }
                case ',': {
                    this.dropBufferUntil(i);
                    int n = state;
                    switch (n) {
                        case 4: {
                            ++i;
                            state = 1;
                            continue block47;
                        }
                        case 5: {
                            ++i;
                            state = 2;
                            continue block47;
                        }
                    }
                    throw this.dieWithFailureMessage(i, state);
                }
                case ']': {
                    int n = state;
                    switch (n) {
                        case 4: 
                        case 6: {
                            Tuple2 t;
                            Option<Tuple2<J, Object>> option = this.tryCloseCollection(stackHead, stackTail, i);
                            if (!(option instanceof Some)) {
                                if (None$.MODULE$.equals(option)) {
                                    ObjArrVisitor stackTailHead = (ObjArrVisitor)stackTail.head();
                                    stackTail = (List)stackTail.tail();
                                    stackHead = stackTailHead;
                                    ++i;
                                    state = this.collectionEndFor(stackTailHead);
                                    continue block47;
                                }
                                throw new MatchError(option);
                            }
                            Some some = (Some)option;
                            Tuple2 tuple22 = t = (Tuple2)some.value();
                            tuple2 = tuple22;
                            break block47;
                        }
                    }
                    throw this.dieWithFailureMessage(i, state);
                }
                case '}': {
                    int n = state;
                    switch (n) {
                        case 5: 
                        case 7: {
                            Tuple2 t;
                            Option<Tuple2<J, Object>> option = this.tryCloseCollection(stackHead, stackTail, i);
                            if (!(option instanceof Some)) {
                                if (None$.MODULE$.equals(option)) {
                                    ObjArrVisitor stackTailHead = (ObjArrVisitor)stackTail.head();
                                    stackTail = (List)stackTail.tail();
                                    stackHead = stackTailHead;
                                    ++i;
                                    state = this.collectionEndFor(stackTailHead);
                                    continue block47;
                                }
                                throw new MatchError(option);
                            }
                            Some some = (Some)option;
                            Tuple2 tuple23 = t = (Tuple2)some.value();
                            tuple2 = tuple23;
                            break block47;
                        }
                    }
                    throw this.dieWithFailureMessage(i, state);
                }
                default: {
                    throw this.dieWithFailureMessage(i, state);
                }
            }
            break;
        }
        return tuple2;
    }

    public Nothing$ dieWithFailureMessage(int i, int state) {
        String string;
        int n = state;
        switch (n) {
            case 6: {
                string = "json value or ]";
                break;
            }
            case 7: {
                string = "json value or }";
                break;
            }
            case 1: {
                string = "json value";
                break;
            }
            case 2: {
                string = "json string key";
                break;
            }
            case 3: {
                string = ":";
                break;
            }
            case 4: {
                string = ", or ]";
                break;
            }
            case 5: {
                string = ", or }";
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        String expected = string;
        return this.die(i, new StringBuilder(9).append("expected ").append(expected).toString());
    }

    public void failIfNotData(int state, int i) {
        int n = state;
        switch (n) {
            case 1: 
            case 6: {
                break;
            }
            default: {
                throw this.dieWithFailureMessage(i, state);
            }
        }
    }

    public Option<Tuple2<J, Object>> tryCloseCollection(ObjArrVisitor<?, J> stackHead, List<ObjArrVisitor<?, J>> stackTail, int i) {
        Option option;
        if (stackTail.isEmpty()) {
            option = new Some<Tuple2<J, Object>>(new Tuple2<Object, Integer>(this.liftedTree1$1(stackHead, i), BoxesRunTime.boxToInteger(i + 1)));
        } else {
            BoxedUnit boxedUnit;
            ObjArrVisitor ctxt2 = ((ObjArrVisitor)stackTail.head()).narrow();
            try {
                ctxt2.visitValue(stackHead.visitEnd(i), i);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable x$12) {
                PartialFunction<Throwable, Nothing$> catchExpr$11 = this.reject(i);
                if (catchExpr$11.isDefinedAt(x$12)) {
                    boxedUnit = catchExpr$11.apply(x$12);
                }
                throw x$12;
            }
            option = None$.MODULE$;
        }
        return option;
    }

    public int collectionEndFor(ObjArrVisitor<?, ?> stackHead) {
        return stackHead.isObj() ? 5 : 4;
    }

    public final int parseStringSimple(int i) {
        int j = i;
        int c = this.elemOps.toUnsignedInt(this.getCharSafe(j));
        while (c != 34) {
            if (c < 32) {
                throw this.die(j, new StringBuilder(25).append("control char (").append(c).append(") in string").toString());
            }
            if (c == 92 || c > 127) {
                return -1 - j;
            }
            c = this.elemOps.toUnsignedInt(this.getCharSafe(++j));
        }
        return j + 1;
    }

    public final int parseStringComplex(int i0) {
        int i = i0;
        int c = this.elemOps.toUnsignedInt(this.getCharSafe(i));
        while (c != 34) {
            if (c < 32) {
                throw this.die(i, new StringBuilder(25).append("control char (").append(c).append(") in string").toString());
            }
            if (c == 92) {
                char c2 = this.getCharSafe(i + 1);
                switch (c2) {
                    case 'b': {
                        this.outputBuilder.append('\b');
                        i += 2;
                        break;
                    }
                    case 'f': {
                        this.outputBuilder.append('\f');
                        i += 2;
                        break;
                    }
                    case 'n': {
                        this.outputBuilder.append('\n');
                        i += 2;
                        break;
                    }
                    case 'r': {
                        this.outputBuilder.append('\r');
                        i += 2;
                        break;
                    }
                    case 't': {
                        this.outputBuilder.append('\t');
                        i += 2;
                        break;
                    }
                    case '\"': {
                        this.outputBuilder.append('\"');
                        i += 2;
                        break;
                    }
                    case '/': {
                        this.outputBuilder.append('/');
                        i += 2;
                        break;
                    }
                    case '\\': {
                        this.outputBuilder.append('\\');
                        i += 2;
                        break;
                    }
                    case 'u': {
                        char d = this.descape(i);
                        this.outputBuilder.appendC(d);
                        i += 6;
                        break;
                    }
                    default: {
                        throw this.die(i + 1, "illegal escape sequence after \\");
                    }
                }
            } else {
                this.outputBuilder.append(c);
                ++i;
            }
            c = this.elemOps.toUnsignedInt(this.getCharSafe(i));
        }
        return i + 1;
    }

    public final int parseStringValue(int i, ObjArrVisitor<?, J> stackHead) {
        int n;
        int k = this.parseStringSimple(i + 1);
        if (k >= 0) {
            this.visitString(i, this.unsafeCharSeqForRange(i + 1, k - i - 2), stackHead);
            n = k;
        } else {
            int k2 = this.parseStringToOutputBuilder(i, k);
            this.visitString(i, this.outputBuilder.makeString(), stackHead);
            n = k2;
        }
        return n;
    }

    public final int parseStringKey(int i, ObjArrVisitor<?, J> stackHead) {
        int n;
        int k = this.parseStringSimple(i + 1);
        if (k >= 0) {
            this.visitStringKey(i, this.unsafeCharSeqForRange(i + 1, k - i - 2), stackHead);
            n = k;
        } else {
            int k2 = this.parseStringToOutputBuilder(i, k);
            this.visitStringKey(i, this.outputBuilder.makeString(), stackHead);
            n = k2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int parseStringToOutputBuilder(int i, int k) {
        void var3_3;
        this.outputBuilder.reset();
        this.appendCharsToBuilder(this.outputBuilder, i + 1, -k - 2 - i);
        int k2 = this.parseStringComplex(-k - 1);
        return (int)var3_3;
    }

    public void visitString(int i, CharSequence s, ObjArrVisitor<?, J> stackHead) {
        Object v = stackHead.subVisitor().visitString(s, i);
        stackHead.narrow().visitValue(v, i);
    }

    public void visitStringKey(int i, CharSequence s, ObjArrVisitor<?, J> stackHead) {
        ObjVisitor obj = (ObjVisitor)stackHead;
        Visitor<?, ?> keyVisitor = obj.visitKey(i);
        obj.visitKeyValue(keyVisitor.visitString(s, i));
    }

    public final Tuple2<J, Object> parseStringTopLevel(int i, Visitor<?, J> facade) {
        Tuple2<J, Integer> tuple2;
        int k = this.parseStringSimple(i + 1);
        if (k >= 0) {
            J res = facade.visitString(this.unsafeCharSeqForRange(i + 1, k - i - 2), i);
            tuple2 = new Tuple2<J, Integer>(res, BoxesRunTime.boxToInteger(k));
        } else {
            int k2 = this.parseStringToOutputBuilder(i, k);
            J res = facade.visitString(this.outputBuilder.makeString(), i);
            tuple2 = new Tuple2<J, Integer>(res, BoxesRunTime.boxToInteger(k2));
        }
        return tuple2;
    }

    private final /* synthetic */ Object liftedTree1$1(ObjArrVisitor stackHead$1, int i$1) {
        Object object;
        try {
            object = stackHead$1.visitEnd(i$1);
        }
        catch (Throwable x$11) {
            PartialFunction<Throwable, Nothing$> catchExpr$10 = this.reject(i$1);
            if (catchExpr$10.isDefinedAt(x$11)) {
                object = catchExpr$10.apply(x$11);
            }
            throw x$11;
        }
        return object;
    }

    public CharParser() {
        BufferingCharParser.$init$(this);
        this.elemOps = CharOps$.MODULE$;
        this.outputBuilder = new CharBuilder(CharBuilder$.MODULE$.$lessinit$greater$default$1());
    }
}

