/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.goldagent;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.games.TWCGame;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Room;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.StepResult;

public class TWCGoldAgent {
    private final TWCGame game;
    private final Set<String> knownLocations;
    private final Set<String> placedObjects;

    public Set<String> knownLocations() {
        return this.knownLocations;
    }

    public Set<String> placedObjects() {
        return this.placedObjects;
    }

    private boolean putAwayObjectsRandomWalk(Random r, int numIterations, String lastLocation) {
        while (true) {
            Object object;
            int MAX_ITERATIONS = 25;
            Room agentLocation = this.game.agentLocation();
            if (this.game.getScore().scoreNormalized() >= 1.0) {
                return true;
            }
            this.knownLocations().add(agentLocation.name());
            ListBuffer<FastObject> visibleObjects = agentLocation.collectVisibleObjects(agentLocation.collectVisibleObjects$default$1());
            visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> obj.isMovable() && !this.placedObjects().contains(obj.name()) ? $this.game.step(new StringBuilder(5).append("take ").append(obj.name()).toString()) : BoxedUnit.UNIT);
            ArrayBuffer inventoryObjects = (ArrayBuffer)this.game.agentInventory().contents().clone();
            inventoryObjects.foreach((Function1<FastObject, Object> & Serializable)iObj -> {
                TWCGoldAgent.$anonfun$putAwayObjectsRandomWalk$2(this, visibleObjects, iObj);
                return BoxedUnit.UNIT;
            });
            if (this.game.locations().length > 1) {
                Object object2 = agentLocation.doorNorth() != null && !agentLocation.doorNorth().isOpen() ? this.game.step("open door to north") : BoxedUnit.UNIT;
                Object object3 = agentLocation.doorSouth() != null && !agentLocation.doorSouth().isOpen() ? this.game.step("open door to south") : BoxedUnit.UNIT;
                Object object4 = agentLocation.doorEast() != null && !agentLocation.doorEast().isOpen() ? this.game.step("open door to east") : BoxedUnit.UNIT;
                Object object5 = agentLocation.doorWest() != null && !agentLocation.doorWest().isOpen() ? this.game.step("open door to west") : BoxedUnit.UNIT;
                ArrayBuffer<String> validDirections = new ArrayBuffer<String>();
                Object object6 = agentLocation.locationNorth() != null ? validDirections.append("north") : BoxedUnit.UNIT;
                Object object7 = agentLocation.locationSouth() != null ? validDirections.append("south") : BoxedUnit.UNIT;
                Object object8 = agentLocation.locationEast() != null ? validDirections.append("east") : BoxedUnit.UNIT;
                Object object9 = agentLocation.locationWest() != null ? validDirections.append("west") : BoxedUnit.UNIT;
                if (validDirections.length() > 1) {
                    int randIdx = r.nextInt(validDirections.length());
                    while (true) {
                        Object a = validDirections.apply(randIdx);
                        String string = lastLocation;
                        if (a != null ? !a.equals(string) : string != null) break;
                        randIdx = r.nextInt(validDirections.length());
                    }
                    object = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(randIdx)).toString());
                } else {
                    object = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(0)).toString());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            if (numIterations >= MAX_ITERATIONS) break;
            lastLocation = agentLocation.name();
            ++numIterations;
        }
        return false;
    }

    private int putAwayObjectsRandomWalk$default$2() {
        return 0;
    }

    private String putAwayObjectsRandomWalk$default$3() {
        return "";
    }

    private boolean mkGoldPathTWC(Random r) {
        StepResult stepResult = this.game.initalStep();
        boolean success = this.putAwayObjectsRandomWalk(r, this.putAwayObjectsRandomWalk$default$2(), this.putAwayObjectsRandomWalk$default$3());
        return success;
    }

    public Tuple2<Object, String[]> mkGoldPath(Random r) {
        boolean success = this.mkGoldPathTWC(r);
        if (!success) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(false), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        String[] path = (String[])((IterableOnceOps)this.game.history().map((Function1<ActionHistory, String> & Serializable)x$1 -> x$1.actionStr())).toArray(ClassTag$.MODULE$.apply(String.class));
        return new Tuple2<Object, String[]>(BoxesRunTime.boxToBoolean(true), path);
    }

    public static final /* synthetic */ void $anonfun$putAwayObjectsRandomWalk$4(TWCGoldAgent $this, String[] cannonicalLocations$1, FastObject iObj$1, FastObject vObj) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cannonicalLocations$1), vObj.name())) {
            Object object = vObj.isContainer() && !vObj.isOpen() && vObj.isOpenable() ? $this.game.step(new StringBuilder(5).append("open ").append(vObj.name()).toString()) : BoxedUnit.UNIT;
            $this.game.step(new StringBuilder(8).append("put ").append(iObj$1.name()).append(" in ").append(vObj.name()).toString());
            $this.placedObjects().add(iObj$1.name());
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$putAwayObjectsRandomWalk$2(TWCGoldAgent $this, ListBuffer visibleObjects$1, FastObject iObj) {
        String[] cannonicalLocations = iObj.canonicalLocations();
        Breaks$.MODULE$.breakable(() -> visibleObjects$1.foreach((Function1<FastObject, Object> & Serializable)vObj -> {
            TWCGoldAgent.$anonfun$putAwayObjectsRandomWalk$4($this, cannonicalLocations, iObj, vObj);
            return BoxedUnit.UNIT;
        }));
    }

    public TWCGoldAgent(TWCGame game) {
        this.game = game;
        this.knownLocations = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        this.placedObjects = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
    }
}

