/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.goldagent;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.ObjectRef;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.games.KitchenGame;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Room;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.StepResult;

public class KitchenGoldAgent {
    private final KitchenGame game;
    private final ArrayBuffer<String> foundIngredients;
    private final Map<String, Set<String>> mapConnections;

    public ArrayBuffer<String> foundIngredients() {
        return this.foundIngredients;
    }

    public Map<String, Set<String>> mapConnections() {
        return this.mapConnections;
    }

    private void makeMapCurrentLocation() {
        block3: {
            Room agentLocation = this.game.agentLocation();
            if ((agentLocation.doorNorth() == null || agentLocation.doorNorth().isOpen()) && agentLocation.locationNorth() != null) {
                this.addMapConnection(agentLocation.name(), agentLocation.locationNorth().name());
            }
            if ((agentLocation.doorSouth() == null || agentLocation.doorSouth().isOpen()) && agentLocation.locationSouth() != null) {
                this.addMapConnection(agentLocation.name(), agentLocation.locationSouth().name());
            }
            if ((agentLocation.doorEast() == null || agentLocation.doorEast().isOpen()) && agentLocation.locationEast() != null) {
                this.addMapConnection(agentLocation.name(), agentLocation.locationEast().name());
            }
            if (agentLocation.doorWest() != null && !agentLocation.doorWest().isOpen() || agentLocation.locationWest() == null) break block3;
            this.addMapConnection(agentLocation.name(), agentLocation.locationWest().name());
        }
    }

    private void addMapConnection(String location1, String location2) {
        if (!this.mapConnections().contains(location1)) {
            this.mapConnections().update(location1, (Set<String>)Set$.MODULE$.apply(Nil$.MODULE$));
        }
        if (!this.mapConnections().contains(location2)) {
            this.mapConnections().update(location2, (Set<String>)Set$.MODULE$.apply(Nil$.MODULE$));
        }
        ((SetOps)this.mapConnections().apply(location1)).add(location2);
        ((SetOps)this.mapConnections().apply(location2)).add(location1);
    }

    private String[] findPathToLocation(String curLocation, String goalLocation, String[] pathSoFar, int numIterations) {
        int MAX_ITERATIONS = 8;
        ArrayBuffer out = new ArrayBuffer();
        String string = curLocation;
        String string2 = goalLocation;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return pathSoFar;
        }
        if (numIterations > MAX_ITERATIONS) {
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        if (this.mapConnections().contains(curLocation)) {
            ObjectRef<String[]> out2 = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Set connectingLocations = (Set)this.mapConnections().apply(curLocation);
            connectingLocations.foreach((Function1<String, Object> & Serializable)connectingLocation -> {
                KitchenGoldAgent.$anonfun$findPathToLocation$1(this, goalLocation, pathSoFar, numIterations, out2, connectingLocation);
                return BoxedUnit.UNIT;
            });
            return (String[])out2.elem;
        }
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    private String[] findPathToLocation$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    private int findPathToLocation$default$4() {
        return 0;
    }

    private boolean moveToLocationRandomWalk(Random r, String location, int numIterations, String lastLocation) {
        while (true) {
            StepResult stepResult;
            int MAX_ITERATIONS = 35;
            Room agentLocation = this.game.agentLocation();
            String string = agentLocation.name();
            String string2 = location;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
            this.makeMapCurrentLocation();
            if (agentLocation.locationNorth() != null) {
                String string3 = agentLocation.locationNorth().name();
                String string4 = location;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    if (agentLocation.doorNorth() == null || agentLocation.doorNorth().isOpen()) {
                        this.game.step("move north");
                        this.makeMapCurrentLocation();
                        return true;
                    }
                }
            }
            if (agentLocation.locationSouth() != null) {
                String string5 = agentLocation.locationSouth().name();
                String string6 = location;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    if (agentLocation.doorSouth() == null || agentLocation.doorSouth().isOpen()) {
                        this.game.step("move south");
                        this.makeMapCurrentLocation();
                        return true;
                    }
                }
            }
            if (agentLocation.locationEast() != null) {
                String string7 = agentLocation.locationEast().name();
                String string8 = location;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    if (agentLocation.doorEast() == null || agentLocation.doorEast().isOpen()) {
                        this.game.step("move east");
                        this.makeMapCurrentLocation();
                        return true;
                    }
                }
            }
            if (agentLocation.locationWest() != null) {
                String string9 = agentLocation.locationWest().name();
                String string10 = location;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    if (agentLocation.doorWest() == null || agentLocation.doorWest().isOpen()) {
                        this.game.step("move west");
                        this.makeMapCurrentLocation();
                        return true;
                    }
                }
            }
            Object object = agentLocation.doorNorth() != null && !agentLocation.doorNorth().isOpen() ? this.game.step("open door to north") : BoxedUnit.UNIT;
            if (agentLocation.locationNorth() != null) {
                String string11 = agentLocation.locationNorth().name();
                String string12 = location;
                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                    this.makeMapCurrentLocation();
                    this.game.step("move north");
                    this.makeMapCurrentLocation();
                    return true;
                }
            }
            Object object2 = agentLocation.doorSouth() != null && !agentLocation.doorSouth().isOpen() ? this.game.step("open door to south") : BoxedUnit.UNIT;
            if (agentLocation.locationSouth() != null) {
                String string13 = agentLocation.locationSouth().name();
                String string14 = location;
                if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                    this.makeMapCurrentLocation();
                    this.game.step("move south");
                    this.makeMapCurrentLocation();
                    return true;
                }
            }
            Object object3 = agentLocation.doorEast() != null && !agentLocation.doorEast().isOpen() ? this.game.step("open door to east") : BoxedUnit.UNIT;
            if (agentLocation.locationEast() != null) {
                String string15 = agentLocation.locationEast().name();
                String string16 = location;
                if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                    this.makeMapCurrentLocation();
                    this.game.step("move east");
                    this.makeMapCurrentLocation();
                    return true;
                }
            }
            Object object4 = agentLocation.doorWest() != null && !agentLocation.doorWest().isOpen() ? this.game.step("open door to west") : BoxedUnit.UNIT;
            if (agentLocation.locationWest() != null) {
                String string17 = agentLocation.locationWest().name();
                String string18 = location;
                if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                    this.makeMapCurrentLocation();
                    this.game.step("move west");
                    this.makeMapCurrentLocation();
                    return true;
                }
            }
            ArrayBuffer<String> validDirections = new ArrayBuffer<String>();
            Object object5 = agentLocation.locationNorth() != null ? validDirections.append("north") : BoxedUnit.UNIT;
            Object object6 = agentLocation.locationSouth() != null ? validDirections.append("south") : BoxedUnit.UNIT;
            Object object7 = agentLocation.locationEast() != null ? validDirections.append("east") : BoxedUnit.UNIT;
            Object object8 = agentLocation.locationWest() != null ? validDirections.append("west") : BoxedUnit.UNIT;
            if (validDirections.length() > 1) {
                int randIdx = r.nextInt(validDirections.length());
                while (true) {
                    Object a = validDirections.apply(randIdx);
                    String string19 = lastLocation;
                    if (a != null ? !a.equals(string19) : string19 != null) break;
                    randIdx = r.nextInt(validDirections.length());
                }
                stepResult = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(randIdx)).toString());
            } else {
                stepResult = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(0)).toString());
            }
            if (numIterations >= MAX_ITERATIONS) break;
            lastLocation = agentLocation.name();
            ++numIterations;
        }
        return false;
    }

    private boolean moveToLocation(Random r, String location) {
        String string = this.game.agentLocation().name();
        String string2 = location;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        String[] path = this.findPathToLocation(this.game.agentLocation().name(), location, this.findPathToLocation$default$3(), this.findPathToLocation$default$4());
        if (path.length > 0) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(path), (Function1<String, Object> & Serializable)pathLoc -> {
                Object object;
                if ($this.game.agentLocation().locationNorth() != null) {
                    String string = $this.game.agentLocation().locationNorth().name();
                    String string2 = pathLoc;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = $this.game.step("move north");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationSouth() != null) {
                    String string = $this.game.agentLocation().locationSouth().name();
                    String string3 = pathLoc;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        object = $this.game.step("move south");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationEast() != null) {
                    String string = $this.game.agentLocation().locationEast().name();
                    String string4 = pathLoc;
                    if (!(string != null ? !string.equals(string4) : string4 != null)) {
                        object = $this.game.step("move east");
                        return object;
                    }
                }
                if ($this.game.agentLocation().locationWest() != null) {
                    String string = $this.game.agentLocation().locationWest().name();
                    String string5 = pathLoc;
                    if (!(string != null ? !string.equals(string5) : string5 != null)) {
                        object = $this.game.step("move west");
                        return object;
                    }
                }
                object = BoxedUnit.UNIT;
                return object;
            });
            return true;
        }
        return this.moveToLocationRandomWalk(r, location, this.moveToLocationRandomWalk$default$3(), this.moveToLocationRandomWalk$default$4());
    }

    private int moveToLocationRandomWalk$default$3() {
        return 0;
    }

    private String moveToLocationRandomWalk$default$4() {
        return "";
    }

    private void collectIngredientsHere() {
        Object object = new Object();
        try {
            ObjectRef<String[]> containersToOpen = ObjectRef.create((String[])((Object[])new String[]{"fridge", "kitchen cupboard"}));
            Room qual$1 = this.game.agentLocation();
            ListBuffer<FastObject> x$1 = qual$1.collectVisibleObjects$default$1();
            ObjectRef<ListBuffer<FastObject>> visibleObjectsInitial = ObjectRef.create(qual$1.collectVisibleObjects(x$1));
            this.game.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)ingredient -> {
                KitchenGoldAgent.$anonfun$collectIngredientsHere$1(this, visibleObjectsInitial, ingredient);
                return BoxedUnit.UNIT;
            });
            if (this.foundIngredients().length() == this.game.recipe().length()) {
                return;
            }
            ((ListBuffer)visibleObjectsInitial.elem).foreach((Function1<FastObject, Object> & Serializable)obj -> {
                KitchenGoldAgent.$anonfun$collectIngredientsHere$3(this, containersToOpen, object, obj);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private boolean mkGoldPathKitchen(Random r) {
        Object object = new Object();
        try {
            StepResult stepResult;
            StepResult stepResult2 = this.game.initalStep();
            if (!this.moveToLocation(r, "kitchen")) {
                return false;
            }
            this.game.step("take cookbook");
            StepResult out1 = this.game.step("read cookbook");
            Room qual$1 = this.game.agentLocation();
            ListBuffer<FastObject> x$12 = qual$1.collectVisibleObjects$default$1();
            ListBuffer<FastObject> visibleObjects = qual$1.collectVisibleObjects(x$12);
            if (((SeqOps)visibleObjects.filter((Function1<FastObject, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(KitchenGoldAgent.$anonfun$mkGoldPathKitchen$1(x$1)))).size() > 0) {
                stepResult = this.game.step("take knife");
            } else {
                this.game.step("open cutlery drawer");
                Room qual$2 = this.game.agentLocation();
                ListBuffer<FastObject> x$22 = qual$2.collectVisibleObjects$default$1();
                ListBuffer<FastObject> visibleObjects2 = qual$2.collectVisibleObjects(x$22);
                Object object2 = ((SeqOps)visibleObjects2.filter((Function1<FastObject, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(KitchenGoldAgent.$anonfun$mkGoldPathKitchen$2(x$2)))).size() == 0 ? this.game.step("open kitchen cupboard") : BoxedUnit.UNIT;
                stepResult = this.game.step("take knife");
            }
            String[] locationsToVisit = (String[])((Object[])new String[]{"kitchen", "pantry", "backyard", "supermarket"});
            Breaks$.MODULE$.breakable(() -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(locationsToVisit), (Function1<String, Object> & Serializable)location -> {
                KitchenGoldAgent.$anonfun$mkGoldPathKitchen$4(this, r, object, location);
                return BoxedUnit.UNIT;
            }));
            if (!this.moveToLocation(r, "kitchen")) {
                return false;
            }
            this.game.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)ingredient -> {
                Object object = ingredient.preparation().contains("chopped") ? $this.game.step(new StringBuilder(5).append("chop ").append(ingredient.name()).toString()) : BoxedUnit.UNIT;
                Object object2 = ingredient.preparation().contains("sliced") ? $this.game.step(new StringBuilder(6).append("slice ").append(ingredient.name()).toString()) : BoxedUnit.UNIT;
                return ingredient.preparation().contains("diced") ? $this.game.step(new StringBuilder(5).append("dice ").append(ingredient.name()).toString()) : BoxedUnit.UNIT;
            });
            this.game.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)ingredient -> {
                Object object = ingredient.preparation().contains("fried") ? $this.game.step(new StringBuilder(14).append("cook ").append(ingredient.name()).append(" in stove").toString()) : BoxedUnit.UNIT;
                return ingredient.preparation().contains("roasted") ? $this.game.step(new StringBuilder(13).append("cook ").append(ingredient.name()).append(" in oven").toString()) : BoxedUnit.UNIT;
            });
            this.game.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)ingredient -> {
                Object object;
                if (ingredient.preparation().contains("grilled")) {
                    if ($this.game.locations().length < 3) {
                        if (!this.moveToLocation(r, "kitchen")) {
                            throw new NonLocalReturnControl$mcZ$sp(object, false);
                        }
                        object = $this.game.step(new StringBuilder(16).append("cook ").append(ingredient.name()).append(" in toaster").toString());
                    } else {
                        if (!this.moveToLocation(r, "backyard")) {
                            throw new NonLocalReturnControl$mcZ$sp(object, false);
                        }
                        object = $this.game.step(new StringBuilder(17).append("cook ").append(ingredient.name()).append(" in barbeque").toString());
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            if (!this.moveToLocation(r, "kitchen")) {
                return false;
            }
            this.game.step("prepare meal");
            StepResult out = this.game.step("eat meal");
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcZ$sp();
        }
    }

    public Tuple2<Object, String[]> mkGoldPath(Random r) {
        boolean success = this.mkGoldPathKitchen(r);
        if (!success) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(false), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        String[] path = (String[])((IterableOnceOps)this.game.history().map((Function1<ActionHistory, String> & Serializable)x$3 -> x$3.actionStr())).toArray(ClassTag$.MODULE$.apply(String.class));
        return new Tuple2<Object, String[]>(BoxesRunTime.boxToBoolean(true), path);
    }

    public static final /* synthetic */ void $anonfun$findPathToLocation$1(KitchenGoldAgent $this, String goalLocation$1, String[] pathSoFar$1, int numIterations$1, ObjectRef out$1, String connectingLocation) {
        block0: {
            String[] path = $this.findPathToLocation(connectingLocation, goalLocation$1, (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(pathSoFar$1), new String[]{connectingLocation}, ClassTag$.MODULE$.apply(String.class)), numIterations$1 + 1);
            if (path.length <= 0 || ((String[])out$1.elem).length <= 0 || path.length >= ((String[])out$1.elem).length) break block0;
            out$1.elem = path;
        }
    }

    public static final /* synthetic */ void $anonfun$collectIngredientsHere$1(KitchenGoldAgent $this, ObjectRef visibleObjectsInitial$1, RecipeIngredient ingredient) {
        ((ListBuffer)visibleObjectsInitial$1.elem).foreach((Function1<FastObject, Object> & Serializable)obj -> {
            Object object;
            String string = obj.name();
            String string2 = ingredient.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                $this.game.step(new StringBuilder(5).append("take ").append(obj.name()).toString());
                object = $this.foundIngredients().append(obj.name());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ void $anonfun$collectIngredientsHere$3(KitchenGoldAgent $this, ObjectRef containersToOpen$1, Object nonLocalReturnKey1$1, FastObject obj) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((String[])containersToOpen$1.elem), obj.name())) {
            $this.game.step(new StringBuilder(5).append("open ").append(obj.name()).toString());
            Room qual$2 = $this.game.agentLocation();
            ListBuffer<FastObject> x$2 = qual$2.collectVisibleObjects$default$1();
            ListBuffer<FastObject> visibleObjects = qual$2.collectVisibleObjects(x$2);
            $this.game.recipe().foreach((Function1<RecipeIngredient, Object> & Serializable)ingredient -> {
                visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> {
                    Object object;
                    String string = obj.name();
                    String string2 = ingredient.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        $this.game.step(new StringBuilder(5).append("take ").append(obj.name()).toString());
                        object = $this.foundIngredients().append(obj.name());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                return BoxedUnit.UNIT;
            });
            $this.game.step(new StringBuilder(6).append("close ").append(obj.name()).toString());
            if ($this.foundIngredients().length() == $this.game.recipe().length()) {
                throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$mkGoldPathKitchen$1(FastObject x$1) {
        String string = x$1.name();
        String string2 = "knife";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mkGoldPathKitchen$2(FastObject x$2) {
        String string = x$2.name();
        String string2 = "knife";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$mkGoldPathKitchen$4(KitchenGoldAgent $this, Random r$1, Object nonLocalReturnKey2$1, String location) {
        if (!$this.moveToLocation(r$1, location)) {
            throw new NonLocalReturnControl$mcZ$sp(nonLocalReturnKey2$1, false);
        }
        $this.collectIngredientsHere();
        if ($this.foundIngredients().length() == $this.game.recipe().length()) {
            throw Breaks$.MODULE$.break();
        }
    }

    public KitchenGoldAgent(KitchenGame game) {
        this.game = game;
        this.foundIngredients = new ArrayBuffer();
        this.mapConnections = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

