/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.data.LoadTWKitchenDataJSON;
import textworldexpress.data.LoadTWKitchenDataJSON$;
import textworldexpress.games.CoinGame;
import textworldexpress.games.CoinGame$;
import textworldexpress.goldagent.CoinGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Coin;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Door;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.Kitchen$;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;

public class CoinGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final LoadTWKitchenDataJSON TWKitchenObjectDatabase = new LoadTWKitchenDataJSON(LoadTWKitchenDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();

    public LoadTWCDataJSON TWCObjectDatabase() {
        return this.TWCObjectDatabase;
    }

    public DoorMaker doorMaker() {
        return this.doorMaker;
    }

    public Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> mkEnvironment(Random r, int numLocations, int numDistractorItems, boolean includeDoors, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        Kitchen kitchen = new Kitchen(r, false, Kitchen$.MODULE$.$lessinit$greater$default$3());
        locations.append(kitchen);
        Object object = numLocations >= 2 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object2 = numLocations >= 3 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object3 = numLocations >= 4 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object4 = numLocations >= 5 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object5 = numLocations >= 6 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object6 = numLocations >= 7 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object7 = numLocations >= 8 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object8 = numLocations >= 9 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object9 = numLocations >= 10 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object10 = numLocations >= 11 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Option map = None$.MODULE$;
        for (int attempts = 0; map.isEmpty() && attempts < 50; ++attempts) {
            map = this.mkConnections(r, locations);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map");
        }
        this.connectRoomsFromMap(r, (Room[][])((Option)map).get(), includeDoors);
        int randomLocationIdx = r.nextInt(locations.length());
        Coin coin = new Coin();
        ((FastObject)locations.apply(randomLocationIdx)).addObject(coin);
        ArrayBuffer<Coin> taskObjects = new ArrayBuffer<Coin>();
        taskObjects.append(coin);
        ArrayBuffer<String> addedDistractorNames = this.addDistractorItems(r, locations, numDistractorItems, (ArrayBuffer<FastObject>)ArrayBuffer$.MODULE$.empty(), fold);
        return new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>(locations, taskObjects);
    }

    public ArrayBuffer<String> addDistractorItems(Random r, ArrayBuffer<Room> locations, int numToAdd, ArrayBuffer<FastObject> taskObjects, String fold) {
        ArrayBuffer<String> objectNamesAdded = new ArrayBuffer<String>();
        taskObjects.foreach((Function1<FastObject, ArrayBuffer> & Serializable)taskObject -> (ArrayBuffer)objectNamesAdded.append(taskObject.name()));
        for (int attempts = 0; objectNamesAdded.length() < numToAdd + taskObjects.length() && attempts < 100; ++attempts) {
            Object object;
            int randLocIdx = r.nextInt(locations.length());
            Room location = locations.apply(randLocIdx);
            FastObject[] objects = (FastObject[])location.contents().toArray(ClassTag$.MODULE$.apply(FastObject.class));
            if (objects.length > 0) {
                int randObjIdx = r.nextInt(objects.length);
                FastObject container = objects[randObjIdx];
                Option<FastObject> distractorItem = this.TWCObjectDatabase().mkRandomObjectByLocation(r, container.name(), fold);
                if (distractorItem.isDefined()) {
                    if (!objectNamesAdded.contains(distractorItem.get().name())) {
                        container.addObject(distractorItem.get());
                        object = objectNamesAdded.append(distractorItem.get().name());
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return objectNamesAdded;
    }

    public void connectRoomsFromMap(Random r, Room[][] map, boolean includeDoors) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map.length).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map[i].length).foreach$mVc$sp(j -> {
            block8: {
                Room queryLoc;
                Room queryLoc2;
                Room queryLoc3;
                Room queryLoc4;
                Room cell = map[i][j];
                if (cell == null) break block8;
                if (i < map.length - 1 && (queryLoc4 = map[i + 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc4.name())) {
                    Option<Door> door;
                    cell.locationNorth_$eq(queryLoc4);
                    queryLoc4.locationSouth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc4.name(), false)).isDefined()) {
                        cell.doorNorth_$eq(door.get());
                        queryLoc4.doorSouth_$eq(door.get());
                    }
                }
                if (i >= 1 && (queryLoc3 = map[i - 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc3.name())) {
                    Option<Door> door;
                    cell.locationSouth_$eq(queryLoc3);
                    queryLoc3.locationNorth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc3.name(), false)).isDefined()) {
                        cell.doorSouth_$eq(door.get());
                        queryLoc3.doorNorth_$eq(door.get());
                    }
                }
                if (j >= 1 && (queryLoc2 = map[i][j - 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc2.name())) {
                    Option<Door> door;
                    cell.locationEast_$eq(queryLoc2);
                    queryLoc2.locationWest_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc2.name(), false)).isDefined()) {
                        cell.doorEast_$eq(door.get());
                        queryLoc2.doorWest_$eq(door.get());
                    }
                }
                if (j < map[i].length - 1 && (queryLoc = map[i][j + 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc.name())) {
                    Option<Door> door;
                    cell.locationWest_$eq(queryLoc);
                    queryLoc.locationEast_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc.name(), false)).isDefined()) {
                        cell.doorWest_$eq(door.get());
                        queryLoc.doorEast_$eq(door.get());
                    }
                }
            }
        }));
    }

    public Tuple2<Object, Object> findEmptyDirection(Random r, Room[][] map, int locX, int locY) {
        Object object = new Object();
        try {
            ArrayBuffer orderToCheck = (ArrayBuffer)r.shuffle((IterableOnce)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), BuildFrom$.MODULE$.buildFromIterableOps());
            orderToCheck.foreach(directionRef -> {
                if (directionRef == 0) {
                    if (locX - 1 >= 0 && map[locX - 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX - 1, locY));
                    }
                } else if (directionRef == 1) {
                    if (locX + 1 < map.length && map[locX + 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX + 1, locY));
                    }
                } else if (directionRef == 2) {
                    if (locY - 1 >= 0 && map[locX][locY - 1] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY - 1));
                    }
                } else if (directionRef == 3 && locY + 1 < map.length && map[locX][locY + 1] == null) {
                    throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY + 1));
                }
            });
            return new Tuple2$mcII$sp(-1, -1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public Option<Room[][]> mkConnections(Random r, ArrayBuffer<Room> locations) {
        int GRID_SIZE = 7;
        Room[][] map = (Room[][])Array$.MODULE$.ofDim(GRID_SIZE, GRID_SIZE, ClassTag$.MODULE$.apply(Room.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(j -> {
            map$4[i$3][j] = null;
        }));
        ArrayBuffer locationsLeft = new ArrayBuffer();
        locationsLeft.insertAll(0, (IterableOnce)r.shuffle(locations, BuildFrom$.MODULE$.buildFromIterableOps()));
        IntRef lastX = IntRef.create(3);
        IntRef lastY = IntRef.create(3);
        map[lastX.elem][lastY.elem] = (Room)locationsLeft.last();
        locationsLeft.remove(locationsLeft.size() - 1);
        ObjectRef<Room> lastLocation = ObjectRef.create(map[lastX.elem][lastY.elem]);
        IntRef attempts = IntRef.create(0);
        ArrayBuffer<Tuple2$mcII$sp> populatedLocations = new ArrayBuffer<Tuple2$mcII$sp>();
        populatedLocations.append(new Tuple2$mcII$sp(lastX.elem, lastY.elem));
        Breaks$.MODULE$.breakable(() -> {
            while (locationsLeft.length() > 0) {
                Object object;
                int refIdx = r.nextInt(populatedLocations.length());
                lastX$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._1$mcI$sp();
                lastY$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._2$mcI$sp();
                lastLocation$1.elem = map[lastX$1.elem][lastY$1.elem];
                int locationIdx = r.nextInt(locationsLeft.length());
                Room location = (Room)locationsLeft.apply(locationIdx);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(location.prefersConnectingTo()), ((Room)lastLocation$1.elem).name())) {
                    Tuple2<Object, Object> tuple2 = this.findEmptyDirection(r, map, lastX$1.elem, lastY$1.elem);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(newX, newY);
                    Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
                    int newX2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
                    int newY2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
                    if (newX2 != -1) {
                        map$4[newX2][newY2] = location;
                        locationsLeft.remove(locationIdx);
                        object = populatedLocations.append(new Tuple2$mcII$sp(newX2, newY2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                ++attempts$1.elem;
                if (attempts$1.elem <= 100) continue;
                throw Breaks$.MODULE$.break();
            }
        });
        if (locationsLeft.length() > 0) {
            return None$.MODULE$;
        }
        return new Some<Room[][]>(map);
    }

    public CoinGame mkGame(long seed, int numLocations, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        props.update("numLocations", BoxesRunTime.boxToInteger(numLocations));
        props.update("numDistractorItems", BoxesRunTime.boxToInteger(numDistractorItems));
        props.update("includeDoors", includeDoors ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        props.update("limitInventorySize", limitInventorySize ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple2 = this.mkEnvironment(r, numLocations, numDistractorItems, includeDoors, fold);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayBuffer<Room> locations = tuple2._1();
        ArrayBuffer<FastObject> taskObjects = tuple2._2();
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple22 = new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>(locations, taskObjects);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple23 = tuple22;
        ArrayBuffer<Room> locations2 = tuple23._1();
        ArrayBuffer<FastObject> taskObjects2 = tuple23._2();
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        ArrayBuffer<FastObject> x$2 = taskObjects2;
        boolean x$3 = limitInventorySize;
        scala.collection.immutable.Map<String, Object> x$4 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$5 = CoinGame$.MODULE$.$lessinit$greater$default$4();
        CoinGame game = new CoinGame(x$1, x$2, x$3, x$5, x$4);
        return game;
    }

    public Tuple2<CoinGame, String[]> mkGameWithGoldPath(long seed, int numLocations, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                CoinGame game = this.mkGame(seed, numLocations, numDistractorItems, includeDoors, limitInventorySize, fold);
                CoinGoldAgent goldAgent = new CoinGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        CoinGame game = this.mkGame(seed, numLocations, numDistractorItems, includeDoors, limitInventorySize, fold);
        return new Tuple2<CoinGame, String[]>(game, (String[])goldPath.elem);
    }
}

