/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashMapBuilder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$EmptyMap$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;

public final class MapBuilderImpl<K, V>
implements ReusableBuilder<Tuple2<K, V>, Map<K, V>> {
    private Map<K, V> elems = Map$EmptyMap$.MODULE$;
    private boolean switchedToHashMapBuilder = false;
    private HashMapBuilder<K, V> hashMapBuilder;

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<Map<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    public <V0> V0 getOrElse(K key, V0 value) {
        if (this.hashMapBuilder != null) {
            return this.hashMapBuilder.getOrElse(key, value);
        }
        return (V0)this.elems.getOrElse(key, (Function0<Object> & Serializable)() -> value);
    }

    @Override
    public Map<K, V> result() {
        if (this.switchedToHashMapBuilder) {
            return this.hashMapBuilder.result();
        }
        return this.elems;
    }

    public MapBuilderImpl<K, V> addOne(K key, V value) {
        if (this.switchedToHashMapBuilder) {
            this.hashMapBuilder.addOne(key, value);
        } else if (this.elems.size() < 4) {
            this.elems = (Map)this.elems.updated(key, value);
        } else if (this.elems.contains(key)) {
            this.elems = (Map)this.elems.updated(key, value);
        } else {
            this.switchedToHashMapBuilder = true;
            if (this.hashMapBuilder == null) {
                this.hashMapBuilder = new HashMapBuilder();
            }
            ((Map.Map4)this.elems).buildTo(this.hashMapBuilder);
            this.hashMapBuilder.addOne(key, value);
        }
        return this;
    }

    public MapBuilderImpl<K, V> addOne(Tuple2<K, V> elem) {
        return this.addOne(elem._1(), elem._2());
    }

    public MapBuilderImpl<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        if (this.switchedToHashMapBuilder) {
            this.hashMapBuilder.addAll((IterableOnce)xs);
            return this;
        }
        return (MapBuilderImpl)Growable.addAll$(this, xs);
    }
}

