/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function1;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.SetHashIterator;
import scala.collection.immutable.SetIterator;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.SetReverseIterator;
import scala.collection.immutable.StrictOptimizedSetOps;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class HashSet<A>
extends AbstractSet<A>
implements DefaultSerializable,
StrictOptimizedSetOps<A, HashSet, HashSet<A>> {
    private final BitmapIndexedSetNode<A> rootNode;

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    public BitmapIndexedSetNode<A> rootNode() {
        return this.rootNode;
    }

    private HashSet<A> newHashSetOrThis(BitmapIndexedSetNode<A> newRootNode) {
        if (this.rootNode() == newRootNode) {
            return this;
        }
        return new HashSet<A>(newRootNode);
    }

    @Override
    public IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public int knownSize() {
        return this.rootNode().size();
    }

    @Override
    public int size() {
        return this.rootNode().size();
    }

    @Override
    public boolean isEmpty() {
        return this.rootNode().size() == 0;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new SetIterator<A>(this.rootNode());
    }

    public Iterator<A> reverseIterator() {
        return new SetReverseIterator<A>(this.rootNode());
    }

    @Override
    public boolean contains(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        return this.rootNode().contains(element, elementUnimprovedHash, elementHash, 0);
    }

    public HashSet<A> incl(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().updated((Object)element, elementUnimprovedHash, elementHash, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newRootNode);
    }

    public HashSet<A> excl(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().removed((Object)element, elementUnimprovedHash, elementHash, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newRootNode);
    }

    @Override
    public HashSet<A> concat(IterableOnce<A> that) {
        HashSet hashSet;
        if (that instanceof HashSet) {
            SetNode newNode;
            HashSet hashSet2 = (HashSet)that;
            hashSet = this.isEmpty() ? hashSet2 : ((newNode = this.rootNode().concat((SetNode)hashSet2.rootNode(), 0)) == hashSet2.rootNode() ? hashSet2 : this.newHashSetOrThis((BitmapIndexedSetNode<A>)newNode));
        } else if (that instanceof scala.collection.mutable.HashSet) {
            HashSet.HashSetIterator hashSetIterator;
            scala.collection.mutable.HashSet hashSet3 = (scala.collection.mutable.HashSet)that;
            if (hashSet3 == null) {
                throw null;
            }
            HashSet.HashSetIterator hashSetIterator2 = hashSetIterator = new HashSet.HashSetIterator<HashSet.Node<A>>(hashSet3){

                public HashSet.Node<A> extract(HashSet.Node<A> nd) {
                    return nd;
                }
            };
            hashSetIterator = null;
            HashSet.HashSetIterator iter = hashSetIterator2;
            SetNode current = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = (HashSet.Node)iter.next();
                int unimproveHash_improvedHash = next.hash();
                int n = unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16;
                int improved = Hashing$.MODULE$.improve(n);
                if ((current = ((BitmapIndexedSetNode)current).updated(next.key(), n, improved, 0)) == this.rootNode()) continue;
                int maskFrom_shift = 0;
                int n2 = improved >>> maskFrom_shift & 0x1F;
                int shallowlyMutableNodeMap = 1 << n2;
                while (iter.hasNext()) {
                    HashSet.Node next2 = (HashSet.Node)iter.next();
                    int unimproveHash_improvedHash2 = next2.hash();
                    int n3 = unimproveHash_improvedHash2 ^ unimproveHash_improvedHash2 >>> 16;
                    int improved2 = Hashing$.MODULE$.improve(n3);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(next2.key(), n3, improved2, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            hashSet = this;
        } else {
            Iterator<A> iter = that.iterator();
            SetNode current = this.rootNode();
            while (iter.hasNext()) {
                int improved;
                int originalHash;
                A element = iter.next();
                if ((current = ((BitmapIndexedSetNode)current).updated((Object)element, originalHash = Statics.anyHash(element), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
                int maskFrom_shift = 0;
                int n = improved >>> maskFrom_shift & 0x1F;
                int shallowlyMutableNodeMap = 1 << n;
                while (iter.hasNext()) {
                    A element2 = iter.next();
                    int originalHash2 = Statics.anyHash(element2);
                    int improved3 = Hashing$.MODULE$.improve(originalHash2);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(element2, originalHash2, improved3, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            hashSet = this;
        }
        return hashSet;
    }

    @Override
    public HashSet<A> tail() {
        A $minus_elem = this.head();
        return this.excl((Object)$minus_elem);
    }

    @Override
    public A head() {
        return this.iterator().next();
    }

    @Override
    public A last() {
        return this.reverseIterator().next();
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = this.rootNode();
        if (bitmapIndexedSetNode == null) {
            throw null;
        }
        BitmapIndexedSetNode<A> foreach_this = bitmapIndexedSetNode;
        int foreach_thisPayloadArity = foreach_this.payloadArity();
        for (int foreach_i = 0; foreach_i < foreach_thisPayloadArity; ++foreach_i) {
            f.apply(foreach_this.content()[foreach_i]);
        }
        int foreach_thisNodeArity = foreach_this.nodeArity();
        for (int foreach_j = 0; foreach_j < foreach_thisNodeArity; ++foreach_j) {
            ((SetNode)foreach_this.getNode(foreach_j)).foreach(f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        if (!(that instanceof HashSet)) return Set.equals$(this, that);
        HashSet hashSet = (HashSet)that;
        if (this == hashSet) return true;
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = this.rootNode();
        BitmapIndexedSetNode<A> bitmapIndexedSetNode2 = hashSet.rootNode();
        if (bitmapIndexedSetNode != null) {
            if (!((Object)bitmapIndexedSetNode).equals(bitmapIndexedSetNode2)) return false;
            return true;
        }
        if (bitmapIndexedSetNode2 == null) return true;
        return false;
    }

    @Override
    public String className() {
        return "HashSet";
    }

    @Override
    public int hashCode() {
        SetHashIterator<A> it = new SetHashIterator<A>(this.rootNode());
        return MurmurHash3$.MODULE$.unorderedHash(it, MurmurHash3$.MODULE$.setSeed());
    }

    public HashSet<A> diff(Set<A> that) {
        HashSet<A> hashSet;
        if (this.isEmpty()) {
            return this;
        }
        if (that instanceof HashSet) {
            HashSet hashSet2 = (HashSet)that;
            hashSet = hashSet2.isEmpty() ? this : (((BitmapIndexedSetNode)this.rootNode().diff((SetNode)hashSet2.rootNode(), 0)).size() == 0 ? HashSet$.MODULE$.empty() : super.newHashSetOrThis((BitmapIndexedSetNode<A>)this.rootNode().diff((SetNode)hashSet2.rootNode(), 0)));
        } else if (that instanceof scala.collection.mutable.HashSet) {
            HashSet.HashSetIterator hashSetIterator;
            scala.collection.mutable.HashSet hashSet3 = (scala.collection.mutable.HashSet)that;
            if (hashSet3 == null) {
                throw null;
            }
            HashSet.HashSetIterator hashSetIterator2 = hashSetIterator = new /* invalid duplicate definition of identical inner class */;
            hashSetIterator = null;
            HashSet.HashSetIterator iter = hashSetIterator2;
            SetNode curr = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = (HashSet.Node)iter.next();
                int unimproveHash_improvedHash = next.hash();
                int n = unimproveHash_improvedHash ^ unimproveHash_improvedHash >>> 16;
                int improved = Hashing$.MODULE$.improve(n);
                if ((curr = ((BitmapIndexedSetNode)curr).removed(next.key(), n, improved, 0)) == this.rootNode()) continue;
                if (((BitmapIndexedSetNode)curr).size() == 0) {
                    return HashSet$.MODULE$.empty();
                }
                while (iter.hasNext()) {
                    HashSet.Node next2 = (HashSet.Node)iter.next();
                    int unimproveHash_improvedHash2 = next2.hash();
                    int n2 = unimproveHash_improvedHash2 ^ unimproveHash_improvedHash2 >>> 16;
                    int improved2 = Hashing$.MODULE$.improve(n2);
                    ((BitmapIndexedSetNode)curr).removeWithShallowMutations(next2.key(), n2, improved2);
                    if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                    return HashSet$.MODULE$.empty();
                }
                return new HashSet<A>(curr);
            }
            hashSet = this;
        } else {
            Object object;
            int thatKnownSize = that.knownSize();
            if (thatKnownSize == 0) {
                object = this;
            } else if (thatKnownSize <= this.size()) {
                object = this.removedAllWithShallowMutations(that);
            } else {
                Function1<Object, Object> & Serializable filterNot_pred = (Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(that.contains(elem));
                boolean filterImpl_isFlipped = true;
                SetNode filterImpl_newRootNode = this.rootNode().filterImpl(filterNot_pred, filterImpl_isFlipped);
                object = filterImpl_newRootNode == this.rootNode() ? this : (((BitmapIndexedSetNode)filterImpl_newRootNode).size() == 0 ? HashSet$.MODULE$.empty() : new HashSet<A>(filterImpl_newRootNode));
            }
            hashSet = object;
        }
        return hashSet;
    }

    private HashSet<A> removedAllWithShallowMutations(IterableOnce<A> that) {
        Iterator<A> iter = that.iterator();
        SetNode curr = this.rootNode();
        while (iter.hasNext()) {
            int improved;
            int originalHash;
            A next = iter.next();
            if ((curr = ((BitmapIndexedSetNode)curr).removed((Object)next, originalHash = Statics.anyHash(next), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
            if (((BitmapIndexedSetNode)curr).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            while (iter.hasNext()) {
                A next2 = iter.next();
                int originalHash2 = Statics.anyHash(next2);
                int improved2 = Hashing$.MODULE$.improve(originalHash2);
                ((BitmapIndexedSetNode)curr).removeWithShallowMutations(next2, originalHash2, improved2);
                if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                return HashSet$.MODULE$.empty();
            }
            return new HashSet<A>(curr);
        }
        return this;
    }

    @Override
    public HashSet<A> filterImpl(Function1<A, Object> pred, boolean isFlipped) {
        SetNode newRootNode = this.rootNode().filterImpl((Function1)pred, isFlipped);
        if (newRootNode == this.rootNode()) {
            return this;
        }
        if (((BitmapIndexedSetNode)newRootNode).size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        return new HashSet<A>(newRootNode);
    }

    @Override
    public HashSet<A> drop(int n) {
        return (HashSet)IterableOps.drop$(this, n);
    }

    public HashSet(BitmapIndexedSetNode<A> rootNode) {
        this.rootNode = rootNode;
        Statics.releaseFence();
    }

    public HashSet() {
        this(SetNode$.MODULE$.empty());
    }
}

