/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.ArrayOps$ArrayIterator$mcB$sp;
import scala.collection.ArrayOps$ArrayIterator$mcC$sp;
import scala.collection.ArrayOps$ArrayIterator$mcD$sp;
import scala.collection.ArrayOps$ArrayIterator$mcF$sp;
import scala.collection.ArrayOps$ArrayIterator$mcI$sp;
import scala.collection.ArrayOps$ArrayIterator$mcJ$sp;
import scala.collection.ArrayOps$ArrayIterator$mcS$sp;
import scala.collection.ArrayOps$ArrayIterator$mcV$sp;
import scala.collection.ArrayOps$ArrayIterator$mcZ$sp;
import scala.collection.EvidenceIterableFactoryDefaults;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public abstract class ArraySeq<A>
extends AbstractSeq<A>
implements Serializable,
EvidenceIterableFactoryDefaults<A, ArraySeq, ClassTag>,
scala.collection.immutable.IndexedSeq<A>,
StrictOptimizedSeqOps<A, ArraySeq, ArraySeq<A>> {
    @Override
    public IterableOps fromSpecific(IterableOnce coll) {
        return EvidenceIterableFactoryDefaults.fromSpecific$(this, coll);
    }

    @Override
    public Builder<A, ArraySeq<A>> newSpecificBuilder() {
        return EvidenceIterableFactoryDefaults.newSpecificBuilder$(this);
    }

    @Override
    public IterableOps empty() {
        return EvidenceIterableFactoryDefaults.empty$(this);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> o) {
        return scala.collection.immutable.IndexedSeq.sameElements$(this, o);
    }

    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<A> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$(this, len);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public abstract ClassTag<?> elemTag();

    @Override
    public SeqFactory<ArraySeq> iterableFactory() {
        return ArraySeq$.MODULE$.untagged();
    }

    public abstract Object unsafeArray();

    public ArraySeq$ evidenceIterableFactory() {
        return ArraySeq$.MODULE$;
    }

    @Override
    public ClassTag<A> iterableEvidence() {
        return this.elemTag();
    }

    @Override
    public abstract A apply(int var1) throws ArrayIndexOutOfBoundsException;

    @Override
    public <B> ArraySeq<B> updated(int index, B elem) {
        Object[] dest = new Object[this.length()];
        Array$.MODULE$.copy(this.unsafeArray(), 0, dest, 0, this.length());
        dest[index] = elem;
        return ArraySeq$.MODULE$.unsafeWrapArray(dest);
    }

    @Override
    public <B> ArraySeq<B> map(Function1<A, B> f) {
        Object[] a = new Object[this.length()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = f.apply(this.apply(i));
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(a);
    }

    @Override
    public <B> ArraySeq<B> appended(B elem) {
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), elem, ClassTag$.MODULE$.Any()));
    }

    @Override
    public ArraySeq<A> drop(int n) {
        if (n <= 0) {
            return this;
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.drop$extension(this.unsafeArray(), n));
    }

    @Override
    public ArraySeq<A> slice(int from, int until) {
        if (from <= 0 && Array.getLength(this.unsafeArray()) <= until) {
            return this;
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.slice$extension(this.unsafeArray(), from, until));
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, A, B> f) {
        Object array = this.unsafeArray();
        B b = z;
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object a = ScalaRunTime$.MODULE$.array_apply(array, i);
            b = f.apply(b, a);
        }
        return b;
    }

    @Override
    public ArraySeq<A> tail() {
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.tail$extension(this.unsafeArray()));
    }

    @Override
    public String className() {
        return "ArraySeq";
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        int elemsToCopyToArray_max_y;
        int elemsToCopyToArray_min_y;
        int n = Array.getLength(xs);
        int elemsToCopyToArray_srcLen = this.length();
        int n2 = Math.min(len, elemsToCopyToArray_srcLen);
        int n3 = Math.min(n2, elemsToCopyToArray_min_y = n - start);
        int n4 = Math.max(n3, elemsToCopyToArray_max_y = 0);
        if (n4 > 0) {
            Array$.MODULE$.copy(this.unsafeArray(), 0, xs, start, n4);
        }
        return n4;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    public static final class ofBoolean
    extends ArraySeq<Object> {
        private final boolean[] unsafeArray;

        public boolean[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.BooleanManifest elemTag() {
            return ClassTag$.MODULE$.Boolean();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public boolean apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mZc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofBoolean) {
                ofBoolean ofBoolean2 = (ofBoolean)that;
                bl = Arrays.equals(this.unsafeArray(), ofBoolean2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcZ$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean(elem);
                object = new ofBoolean((boolean[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, bl, ClassTag$.MODULE$.Boolean()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean(elem);
                object = new ofBoolean((boolean[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), bl, ClassTag$.MODULE$.Boolean()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofBoolean(boolean[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofByte
    extends ArraySeq<Object> {
        private final byte[] unsafeArray;

        public byte[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.ByteManifest elemTag() {
            return ClassTag$.MODULE$.Byte();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public byte apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mBc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofByte) {
                ofByte ofByte2 = (ofByte)that;
                bl = Arrays.equals(this.unsafeArray(), ofByte2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcB$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte(elem);
                object = new ofByte((byte[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, by, ClassTag$.MODULE$.Byte()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte(elem);
                object = new ofByte((byte[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), by, ClassTag$.MODULE$.Byte()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofByte(byte[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofChar
    extends ArraySeq<Object> {
        private final char[] unsafeArray;

        public char[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.CharManifest elemTag() {
            return ClassTag$.MODULE$.Char();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public char apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mCc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofChar) {
                ofChar ofChar2 = (ofChar)that;
                bl = Arrays.equals(this.unsafeArray(), ofChar2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcC$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Character) {
                char c = BoxesRunTime.unboxToChar(elem);
                object = new ofChar((char[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, Character.valueOf(c), ClassTag$.MODULE$.Char()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Character) {
                char c = BoxesRunTime.unboxToChar(elem);
                object = new ofChar((char[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), Character.valueOf(c), ClassTag$.MODULE$.Char()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        @Override
        public StringBuilder addString(StringBuilder sb, String start, String sep, String end) {
            return new ArraySeq.ofChar(this.unsafeArray()).addString(sb, start, sep, end);
        }

        public ofChar(char[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofDouble
    extends ArraySeq<Object> {
        private final double[] unsafeArray;

        public double[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.DoubleManifest elemTag() {
            return ClassTag$.MODULE$.Double();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public double apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mDc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofDouble) {
                ofDouble ofDouble2 = (ofDouble)that;
                bl = Arrays.equals(this.unsafeArray(), ofDouble2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcD$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Double) {
                double d = BoxesRunTime.unboxToDouble(elem);
                object = new ofDouble((double[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, d, ClassTag$.MODULE$.Double()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Double) {
                double d = BoxesRunTime.unboxToDouble(elem);
                object = new ofDouble((double[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), d, ClassTag$.MODULE$.Double()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofDouble(double[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofFloat
    extends ArraySeq<Object> {
        private final float[] unsafeArray;

        public float[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.FloatManifest elemTag() {
            return ClassTag$.MODULE$.Float();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public float apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mFc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofFloat) {
                ofFloat ofFloat2 = (ofFloat)that;
                bl = Arrays.equals(this.unsafeArray(), ofFloat2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcF$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Float) {
                float f = BoxesRunTime.unboxToFloat(elem);
                object = new ofFloat((float[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, Float.valueOf(f), ClassTag$.MODULE$.Float()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Float) {
                float f = BoxesRunTime.unboxToFloat(elem);
                object = new ofFloat((float[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), Float.valueOf(f), ClassTag$.MODULE$.Float()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofFloat(float[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofInt
    extends ArraySeq<Object> {
        private final int[] unsafeArray;

        public int[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.IntManifest elemTag() {
            return ClassTag$.MODULE$.Int();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public int apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mIc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofInt) {
                ofInt ofInt2 = (ofInt)that;
                bl = Arrays.equals(this.unsafeArray(), ofInt2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcI$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Integer) {
                int n = BoxesRunTime.unboxToInt(elem);
                object = new ofInt((int[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, n, ClassTag$.MODULE$.Int()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Integer) {
                int n = BoxesRunTime.unboxToInt(elem);
                object = new ofInt((int[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), n, ClassTag$.MODULE$.Int()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        @Override
        public int apply$mcII$sp(int i) {
            return this.unsafeArray()[i];
        }

        public ofInt(int[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofLong
    extends ArraySeq<Object> {
        private final long[] unsafeArray;

        public long[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.LongManifest elemTag() {
            return ClassTag$.MODULE$.Long();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public long apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mJc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofLong) {
                ofLong ofLong2 = (ofLong)that;
                bl = Arrays.equals(this.unsafeArray(), ofLong2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcJ$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Long) {
                long l = BoxesRunTime.unboxToLong(elem);
                object = new ofLong((long[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, l, ClassTag$.MODULE$.Long()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Long) {
                long l = BoxesRunTime.unboxToLong(elem);
                object = new ofLong((long[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), l, ClassTag$.MODULE$.Long()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofLong(long[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofRef<T>
    extends ArraySeq<T> {
        private final T[] unsafeArray;

        public T[] unsafeArray() {
            return this.unsafeArray;
        }

        @Override
        public ClassTag<T> elemTag() {
            return ClassTag$.MODULE$.apply(this.unsafeArray().getClass().getComponentType());
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public T apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofRef) {
                ofRef ofRef2 = (ofRef)that;
                bl = Array$.MODULE$.equals(this.unsafeArray(), ofRef2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayOps.ArrayIterator(this.unsafeArray());
        }

        public ofRef(T[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofShort
    extends ArraySeq<Object> {
        private final short[] unsafeArray;

        public short[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.ShortManifest elemTag() {
            return ClassTag$.MODULE$.Short();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public short apply(int i) throws ArrayIndexOutOfBoundsException {
            return this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mSc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofShort) {
                ofShort ofShort2 = (ofShort)that;
                bl = Arrays.equals(this.unsafeArray(), ofShort2.unsafeArray());
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ArrayOps$ArrayIterator$mcS$sp(this.unsafeArray());
        }

        @Override
        public <B> ArraySeq<B> updated(int index, B elem) {
            Object object;
            if (elem instanceof Short) {
                short s = BoxesRunTime.unboxToShort(elem);
                object = new ofShort((short[])ArrayOps$.MODULE$.updated$extension(this.unsafeArray(), index, s, ClassTag$.MODULE$.Short()));
            } else {
                object = super.updated(index, (Object)elem);
            }
            return object;
        }

        @Override
        public <B> ArraySeq<B> appended(B elem) {
            Object object;
            if (elem instanceof Short) {
                short s = BoxesRunTime.unboxToShort(elem);
                object = new ofShort((short[])ArrayOps$.MODULE$.appended$extension(this.unsafeArray(), s, ClassTag$.MODULE$.Short()));
            } else {
                object = super.appended((Object)elem);
            }
            return object;
        }

        public ofShort(short[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }

    public static final class ofUnit
    extends ArraySeq<BoxedUnit> {
        private final BoxedUnit[] unsafeArray;

        public BoxedUnit[] unsafeArray() {
            return this.unsafeArray;
        }

        public ManifestFactory.UnitManifest elemTag() {
            return ClassTag$.MODULE$.Unit();
        }

        @Override
        public int length() {
            return this.unsafeArray().length;
        }

        @Override
        public void apply(int i) throws ArrayIndexOutOfBoundsException {
            BoxedUnit cfr_ignored_0 = this.unsafeArray()[i];
        }

        @Override
        public int hashCode() {
            return MurmurHash3$.MODULE$.arraySeqHash$mVc$sp(this.unsafeArray());
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof ofUnit) {
                ofUnit ofUnit2 = (ofUnit)that;
                bl = this.unsafeArray().length == ofUnit2.unsafeArray().length;
            } else {
                bl = Seq.equals$(this, that);
            }
            return bl;
        }

        @Override
        public Iterator<BoxedUnit> iterator() {
            return new ArrayOps$ArrayIterator$mcV$sp(this.unsafeArray());
        }

        @Override
        public void apply$mcVI$sp(int i) {
            BoxedUnit cfr_ignored_0 = this.unsafeArray()[i];
        }

        public ofUnit(BoxedUnit[] unsafeArray) {
            this.unsafeArray = unsafeArray;
        }
    }
}

