#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time     : 2018/9/29 15:09
# @Author   : Peter
# @Des       : 
# @File        : CompanyInfoModel
# @Software: PyCharm
from XX.Model.SqlAlchemy.BaseModel import *
from sqlalchemy import Column, Integer, String, Text
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class CompanyInfoModel(Base, BaseModel):
    __tablename__ = 'company_info'

    id = Column(Integer, primary_key=True)
    com_id = Column(Integer, index=True)
    web_key = Column(String(255, 'utf8mb4_unicode_ci'))
    logo = Column(String(255, 'utf8mb4_unicode_ci'))
    name = Column(String(255, 'utf8mb4_unicode_ci'))
    tel = Column(String(255, 'utf8mb4_unicode_ci'))
    email = Column(String(255, 'utf8mb4_unicode_ci'))
    web_url = Column(String(255, 'utf8mb4_unicode_ci'))
    Address = Column(String(255, 'utf8mb4_unicode_ci'))
    AnnualReports = Column(String(255, 'utf8mb4_unicode_ci'))
    CreditCode = Column(String(255, 'utf8mb4_unicode_ci'))
    taxpayer_no = Column(String(255, 'utf8mb4_unicode_ci'))
    No = Column(String(255, 'utf8mb4_unicode_ci'))
    organization_no = Column(String(255, 'utf8mb4_unicode_ci'))
    Oper_id = Column(Integer)
    OperName = Column(String(255, 'utf8mb4_unicode_ci'))
    RegistCapi = Column(String(255, 'utf8mb4_unicode_ci'))
    Status = Column(String(255, 'utf8mb4_unicode_ci'))
    StartDate = Column(String(255, 'utf8mb4_unicode_ci'))
    EconKind = Column(String(255, 'utf8mb4_unicode_ci'))
    staff_num = Column(String(255, 'utf8mb4_unicode_ci'))
    TermStart = Column(String(255, 'utf8mb4_unicode_ci'))
    TeamEnd = Column(String(255, 'utf8mb4_unicode_ci'))
    BelongOrg = Column(String(255, 'utf8mb4_unicode_ci'))
    CheckDate = Column(String(255, 'utf8mb4_unicode_ci'))
    en_name = Column(String(255, 'utf8mb4_unicode_ci'))
    register_addr = Column(String(255, 'utf8mb4_unicode_ci'))
    industry_belong = Column(String(255, 'utf8mb4_unicode_ci'))
    used_name = Column(String(255, 'utf8mb4_unicode_ci'))
    location = Column(String(255, 'utf8mb4_unicode_ci'))
    Scope = Column(Text(collation='utf8mb4_unicode_ci'))
    intro = Column(Text(collation='utf8mb4_unicode_ci'))
    EndDate = Column(String(255, 'utf8mb4_unicode_ci'))
    Province = Column(String(50, 'utf8mb4_unicode_ci'))
    Industry = Column(String(255, 'utf8mb4_unicode_ci'))
    ImageUrl = Column(String(255, 'utf8mb4_unicode_ci'))
    OrgNo = Column(String(255, 'utf8mb4_unicode_ci'))
    EnglishName = Column(String(255, 'utf8mb4_unicode_ci'))
    Type = Column(String(255, 'utf8mb4_unicode_ci'))
    Tag = Column(String(255, 'utf8mb4_unicode_ci'))
    Financing = Column(String(255, 'utf8mb4_unicode_ci'))
    DbUpdatedDate = Column(Integer)
    ShortStatus = Column(String(20, 'utf8mb4_unicode_ci'))
    IsExpired = Column(String(5, 'utf8mb4_unicode_ci'))
    DUNSNo = Column(String(25, 'utf8mb4_unicode_ci'))
    TaxNo = Column(String(25, 'utf8mb4_unicode_ci'))
    CbuItem = Column(Text(collation='utf8mb4_unicode_ci'))
    AbuItem = Column(Text(collation='utf8mb4_unicode_ci'))
    OpForm = Column(String(5, 'utf8mb4_unicode_ci'))
    RecCap = Column(String(55, 'utf8mb4_unicode_ci'))
    Liquidation = Column(String(5, 'utf8mb4_unicode_ci'))
    SimpleCancellation = Column(String(5, 'utf8mb4_unicode_ci'))
    CompanyStatus = Column(Integer)
    HoldingType = Column(String(25, 'utf8mb4_unicode_ci'))
    id_del = Column(String(255, 'utf8mb4_unicode_ci'))
    create_ts = Column(Integer)
    update_ts = Column(Integer)

    def __init__(self, *arg, **kw):
        self.AbuItem = kw.get("AbuItem", None)
        self.Address = kw.get("Address", None)
        self.AnnualReports = kw.get("AnnualReports", None)
        self.BelongOrg = kw.get("BelongOrg", None)
        self.CbuItem = kw.get("CbuItem", None)
        self.CheckDate = kw.get("CheckDate", None)
        self.CompanyStatus = kw.get("CompanyStatus", None)
        self.CreditCode = kw.get("CreditCode", None)
        self.DUNSNo = kw.get("DUNSNo", None)
        self.DbUpdatedDate = kw.get("DbUpdatedDate", None)
        self.EconKind = kw.get("EconKind", None)
        self.EndDate = kw.get("EndDate", None)
        self.EnglishName = kw.get("EnglishName", None)
        self.Financing = kw.get("Financing", None)
        self.HoldingType = kw.get("HoldingType", None)
        self.ImageUrl = kw.get("ImageUrl", None)
        self.Industry = kw.get("Industry", None)
        self.IsExpired = kw.get("IsExpired", None)
        self.Liquidation = kw.get("Liquidation", None)
        self.No = kw.get("No", None)
        self.OpForm = kw.get("OpForm", None)
        self.Oper_id = kw.get("Oper_id", None)
        self.OperName = kw.get("OperName", None)
        self.OrgNo = kw.get("OrgNo", None)
        self.Province = kw.get("Province", None)
        self.RecCap = kw.get("RecCap", None)
        self.RegistCapi = kw.get("RegistCapi", None)
        self.Scope = kw.get("Scope", None)
        self.ShortStatus = kw.get("ShortStatus", None)
        self.SimpleCancellation = kw.get("SimpleCancellation", None)
        self.StartDate = kw.get("StartDate", None)
        self.Status = kw.get("Status", None)
        self.Tag = kw.get("Tag", None)
        self.TaxNo = kw.get("TaxNo", None)
        self.TeamEnd = kw.get("TeamEnd", None)
        self.TermStart = kw.get("TermStart", None)
        self.Type = kw.get("Type", None)
        self.com_id = kw.get("com_id", None)
        self.web_key = kw.get("web_key", None)
        self.create_ts = kw.get("create_ts", None)
        self.email = kw.get("email", None)
        self.en_name = kw.get("en_name", None)
        self.get = kw.get("get", None)
        self.getAll = kw.get("getAll", None)
        self.getAllIds = kw.get("getAllIds", None)
        self.getByFromId = kw.get("getByFromId", None)
        self.getByFromIdAndMod = kw.get("getByFromIdAndMod", None)
        self.getByName = kw.get("getByName", None)
        self.getColumsByFromIdAndMod = kw.get("getColumsByFromIdAndMod", None)
        self.id = kw.get("id", None)
        self.id_del = kw.get("id_del", None)
        self.industry_belong = kw.get("industry_belong", None)
        self.intro = kw.get("intro", None)
        self.location = kw.get("location", None)
        self.logo = kw.get("logo", None)
        self.metadata = kw.get("metadata", None)
        self.name = kw.get("name", None)
        self.organization_no = kw.get("organization_no", None)
        self.register_addr = kw.get("register_addr", None)
        self.staff_num = kw.get("staff_num", None)
        self.taxpayer_no = kw.get("taxpayer_no", None)
        self.tel = kw.get("tel", None)
        self.updateId = kw.get("updateId", None)
        self.update_ts = kw.get("update_ts", None)
        self.used_name = kw.get("used_name", None)
        self.web_url = kw.get("web_url", None)


if __name__ == '__main__':
    createInitFunction(CompanyInfoModel)
