import { Construct } from '@aws-cdk/core';
import { Bucket, BucketProps } from '@aws-cdk/aws-s3';
export interface DeletableBucketProps extends BucketProps {
    /**
     * If the buckets contains objects, forces the deletion during stack deletion.
     *
     * @default false
     */
    readonly forceDelete?: boolean;
}
export declare class DeletableBucket extends Bucket {
    constructor(scope: Construct, id: string, props?: DeletableBucketProps);
}
