# Generated by Django 2.2.15 on 2020-08-14 17:31

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import polaris.models
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Asset",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("code", models.TextField()),
                (
                    "issuer",
                    models.TextField(
                        validators=[django.core.validators.MinLengthValidator(56)]
                    ),
                ),
                (
                    "significant_decimals",
                    models.IntegerField(
                        default=2,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(7),
                        ],
                    ),
                ),
                ("deposit_enabled", models.BooleanField(default=True)),
                (
                    "deposit_fee_fixed",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "deposit_fee_percent",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=0,
                        max_digits=30,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "deposit_min_amount",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "deposit_max_amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=999999999999999999,
                        max_digits=30,
                    ),
                ),
                ("withdrawal_enabled", models.BooleanField(default=True)),
                (
                    "withdrawal_fee_fixed",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "withdrawal_fee_percent",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=0,
                        max_digits=30,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "withdrawal_min_amount",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "withdrawal_max_amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=999999999999999999,
                        max_digits=30,
                    ),
                ),
                (
                    "send_fee_fixed",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "send_fee_percent",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=0,
                        max_digits=30,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "send_min_amount",
                    models.DecimalField(
                        blank=True, decimal_places=7, default=0, max_digits=30
                    ),
                ),
                (
                    "send_max_amount",
                    models.DecimalField(
                        blank=True,
                        decimal_places=7,
                        default=999999999999999999,
                        max_digits=30,
                    ),
                ),
                ("distribution_seed", polaris.models.EncryptedTextField(null=True)),
                ("sep24_enabled", models.BooleanField(default=False)),
                ("sep6_enabled", models.BooleanField(default=False)),
                ("sep31_enabled", models.BooleanField(default=False)),
                ("symbol", models.TextField(default="$")),
            ],
        ),
        migrations.CreateModel(
            name="Transaction",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                ("paging_token", models.TextField(null=True)),
                (
                    "stellar_account",
                    models.TextField(
                        validators=[django.core.validators.MinLengthValidator(1)]
                    ),
                ),
                (
                    "kind",
                    models.CharField(
                        choices=[
                            ("deposit", "deposit"),
                            ("withdrawal", "withdrawal"),
                            ("send", "send"),
                        ],
                        default="deposit",
                        max_length=20,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending_anchor", "pending_anchor"),
                            ("pending_trust", "pending_trust"),
                            ("pending_user", "pending_user"),
                            (
                                "pending_user_transfer_start",
                                "pending_user_transfer_start",
                            ),
                            ("incomplete", "incomplete"),
                            ("no_market", "no_market"),
                            ("too_small", "too_small"),
                            ("too_large", "too_large"),
                            ("pending_sender", "pending_sender"),
                            ("pending_receiver", "pending_receiver"),
                            (
                                "pending_transaction_info_update",
                                "pending_transaction_info_update",
                            ),
                            (
                                "pending_customer_info_update",
                                "pending_customer_info_update",
                            ),
                            ("completed", "completed"),
                            ("error", "error"),
                            ("pending_external", "pending_external"),
                            ("pending_stellar", "pending_stellar"),
                        ],
                        default="pending_external",
                        max_length=31,
                    ),
                ),
                ("status_eta", models.IntegerField(blank=True, null=True)),
                ("status_message", models.TextField(blank=True, null=True)),
                ("stellar_transaction_id", models.TextField(blank=True, null=True)),
                ("external_transaction_id", models.TextField(blank=True, null=True)),
                (
                    "amount_in",
                    models.DecimalField(
                        blank=True, decimal_places=7, max_digits=30, null=True
                    ),
                ),
                (
                    "amount_out",
                    models.DecimalField(
                        blank=True, decimal_places=7, max_digits=30, null=True
                    ),
                ),
                (
                    "amount_fee",
                    models.DecimalField(
                        blank=True, decimal_places=7, max_digits=30, null=True
                    ),
                ),
                ("started_at", models.DateTimeField(default=polaris.models.utc_now)),
                ("completed_at", models.DateTimeField(null=True)),
                ("from_address", models.TextField(blank=True, null=True)),
                ("to_address", models.TextField(blank=True, null=True)),
                ("required_info_updates", models.TextField(blank=True, null=True)),
                ("required_info_message", models.TextField(blank=True, null=True)),
                ("memo", models.TextField(blank=True, null=True)),
                (
                    "memo_type",
                    models.CharField(
                        choices=[("text", "text"), ("id", "id"), ("hash", "hash")],
                        default="text",
                        max_length=10,
                    ),
                ),
                ("receiving_anchor_account", models.TextField(blank=True, null=True)),
                ("refunded", models.BooleanField(default=False)),
                (
                    "protocol",
                    models.CharField(
                        choices=[
                            ("sep6", "sep6"),
                            ("sep24", "sep24"),
                            ("sep31", "sep31"),
                        ],
                        max_length=5,
                        null=True,
                    ),
                ),
                (
                    "asset",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="polaris.Asset"
                    ),
                ),
            ],
            options={
                "ordering": ("-started_at",),
            },
        ),
    ]
