"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketNoneAuthorizer = exports.WebSocketAuthorizer = exports.WebSocketAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported Authorizer types
 */
var WebSocketAuthorizerType;
(function (WebSocketAuthorizerType) {
    /** Lambda Authorizer */
    WebSocketAuthorizerType["LAMBDA"] = "REQUEST";
})(WebSocketAuthorizerType = exports.WebSocketAuthorizerType || (exports.WebSocketAuthorizerType = {}));
/**
 * An authorizer for WebSocket Apis
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class WebSocketAuthorizer extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketAuthorizer);
            }
            throw error;
        }
        if (props.type === WebSocketAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: props.authorizerName ?? id,
            apiId: props.webSocketApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            authorizerUri: props.authorizerUri,
        });
        this.authorizerId = resource.ref;
    }
    /**
     * Import an existing WebSocket Authorizer into this CDK app.
     */
    static fromWebSocketAuthorizerAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketAuthorizerAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketAuthorizerAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.WebSocketAuthorizer = WebSocketAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketAuthorizer", version: "2.32.0-alpha.0" };
/**
 * Explicitly configure no authorizers on specific WebSocket API routes.
 */
class WebSocketNoneAuthorizer {
    bind(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteAuthorizerBindOptions(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.WebSocketNoneAuthorizer = WebSocketNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
WebSocketNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketNoneAuthorizer", version: "2.32.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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