/**
 * API request wrapper
 *
 * @param url Endpoint to call
 * @param method Request method
 * @param body Request body
 * @returns JSON body of the response
 */
export declare function requestAPI<T>(url: string, method: string, body?: object): Promise<T>;
/**
 * Generate a HTML node.
 *
 * @param tag Node tag
 * @param attributes Node attributes
 * @param text Node text content
 * @param events Node events
 * @returns HTMLElement
 */
export declare function generateNode(tag: string, attributes?: {
    [key: string]: any;
}, text?: string, events?: {
    [key: string]: EventListenerOrEventListenerObject;
}): HTMLElement;
