import { IRenderMime, IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Widget } from '@lumino/widgets';
import { IComment } from '../../tokens';
/**
 * CommentWidget properties
 */
export interface ICommentWidgetProps {
    /**
     * Comment to be displayed
     */
    comment: IComment;
    /**
     * Rendermime registry
     */
    renderMime: IRenderMimeRegistry;
}
/**
 * Comment widget
 */
export declare class CommentWidget extends Widget {
    constructor(props: ICommentWidgetProps);
    /**
     * Create the HTML nodes
     *
     * @param comment Comment to be displayed
     * @param markdownRenderer Markdown renderer
     */
    protected static createNode(comment: IComment, markdownRenderer: IRenderMime.IRenderer): HTMLElement;
    /**
     * Dispose the widget
     */
    dispose(): void;
    protected _markdownRenderer: IRenderMime.IRenderer;
}
