import { Widget } from '@lumino/widgets';
import { MergeView } from 'codemirror';
import { IDiffOptions, IThread } from '../../tokens';
/**
 * Plain Text Diff widget
 */
export declare class PlainTextDiff extends Widget {
    constructor(props: IDiffOptions);
    /**
     * Dispose the widget
     */
    dispose(): void;
    /**
     * Callback to create the diff widget once the widget
     * is attached so CodeMirror get proper size.
     */
    onAfterAttach(): void;
    /**
     * Create wrapper node
     */
    protected static createNode(baseLabel: string, remoteLabel: string): HTMLElement;
    /**
     * Create comment decoration node
     */
    protected static makeCommentDecoration(): HTMLElement;
    /**
     * Add comment gutter on the view port.
     *
     * @param editor CodeMirror editor
     * @param from First line in the view port
     * @param to Last line in the view port
     */
    protected setCommentGutter(editor: CodeMirror.Editor, from: number, to: number, side: 'line' | 'originalLine'): void;
    /**
     * Create the Plain Text Diff view
     *
     * @param props Plain Text diff options
     */
    protected createDiffView(props: IDiffOptions): void;
    /**
     * Start a new discussion
     *
     * @param editor CodeMirror editor
     * @param lineNo Line at which to start a discussion
     * @param side Diff side
     */
    protected createThread(editor: CodeMirror.Editor, lineNo: number, side: 'line' | 'originalLine'): void;
    /**
     * Create the widget associated with a discussion
     *
     * @param thread Discussion
     */
    protected makeThreadWidget(thread: IThread): HTMLElement;
    /**
     * Update discussion displayed when editor view port changes
     *
     * @param editor CodeMirror editor
     * @param from First line displayed
     * @param to Last line displayed
     * @param side Diff side
     */
    protected updateView(editor: CodeMirror.Editor, from: number, to: number, side: 'line' | 'originalLine'): void;
    private addThreadWidget;
    private removeThreadWidget;
    protected _mergeView: MergeView.MergeViewEditor;
    protected _props: IDiffOptions;
    private _threadWidgets;
}
