/**
 * Modified from nbdime
 * https://github.com/jupyter/nbdime/blob/master/packages/labextension/src/widget.ts
 */
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { ServerConnection } from '@jupyterlab/services';
import { JSONObject } from '@lumino/coreutils';
import { Message } from '@lumino/messaging';
import { Panel } from '@lumino/widgets';
import { CellDiffModel } from 'nbdime/lib/diff/model';
import { IDiffOptions, INotebookMapping, IThread, IThreadCell } from '../../tokens';
export declare class NotebookDiff extends Panel {
    constructor(props: IDiffOptions);
    protected computeDiff(previousContent: string, currentContent: string): Promise<JSONObject>;
    dispose(): void;
    protected static mapThreadsOnChunks(baseMapping: INotebookMapping, headMapping: INotebookMapping, chunks: CellDiffModel[][], threads: IThread[]): IThreadCell[];
    /**
     * Handle `'activate-request'` messages.
     */
    protected onActivateRequest(msg: Message): void;
    /**
     * Callback on diff and discussions requests
     *
     * @param pullRequestId Pull request ID
     * @param filename Notebook filename
     * @param data Notebook diff raw data
     * @param renderMime Rendermime registry
     * @param threads List of discussion on the file
     */
    protected onData(pullRequestId: string, filename: string, data: JSONObject, renderMime: IRenderMimeRegistry, threads: IThread[]): void;
    /**
     * Callback on error when requesting the diff or the discussions
     *
     * @param error Error
     */
    protected onError(error: ServerConnection.NetworkError | ServerConnection.ResponseError): void;
    /**
     * Change cell grouping to allow commenting on each cell
     *
     * @param chunks Cell chunks from nbdime
     * @returns New chunks
     */
    protected static reChunkCells(chunks: CellDiffModel[][]): CellDiffModel[][];
    protected scroller: Panel;
}
