import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Panel, Widget } from '@lumino/widgets';
import { NotebookDiffModel } from 'nbdime/lib/diff/model';
import { NotebookDiffWidget } from 'nbdime/lib/diff/widget';
import { IThreadCell } from '../../tokens';
export interface INotebookCellsDiffProps {
    /**
     * Discussions grouped by cell
     */
    comments: IThreadCell[];
    /**
     * Notebook filename
     */
    filename: string;
    /**
     * Notebook diff model
     */
    model: NotebookDiffModel;
    /**
     * Rendermime registry
     */
    renderMime: IRenderMimeRegistry;
    /**
     * Pull request Id
     */
    pullRequestId: string;
}
/**
 * NotebookCellDiff widget
 */
export declare class NotebookCellsDiff extends NotebookDiffWidget {
    constructor(props: INotebookCellsDiffProps);
    /**
     * Add a new discussion
     *
     * @param chunkIndex Cell chunk index
     * @param widget Panel containing the discussion
     * @param lineNo Line of the cell chunk
     * @param side Side of the line selected
     */
    addDiscussion(chunkIndex: number, widget: Panel, lineNo: number, side: 'line' | 'originalLine'): void;
    /**
     * Add widget to the panel
     *
     * If the widget is a cell diff, we add comments widget.
     *
     * @param widget Widget
     */
    addWidget(widget: Widget): void;
    private makeThreadWidget;
    protected _filename: string;
    protected _pullRequestId: string;
    protected __renderMime: IRenderMimeRegistry;
    protected _threads: IThreadCell[];
    private _chunkIndex;
}
