/// <reference types="react" />
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { CommandRegistry } from '@lumino/commands';
import { IPullRequest } from '../../tokens';
/**
 * PullRequestItem properties
 */
export interface IPullRequestItemProps {
    /**
     * Jupyter Front End Commands Registry
     */
    commands: CommandRegistry;
    /**
     * The document registry
     */
    docRegistry: DocumentRegistry;
    /**
     * Pull request description
     */
    pullRequest: IPullRequest;
}
/**
 * PullRequestItem component
 *
 * @param props Component properties
 */
export declare function PullRequestItem(props: IPullRequestItemProps): JSX.Element;
