/// <reference types="react" />
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { CommandRegistry } from '@lumino/commands';
import { IPullRequestGroup } from '../../tokens';
/**
 * BrowserGroup properties
 */
export interface IBrowserGroupProps {
    /**
     * Jupyter Front End Commands Registry
     */
    commands: CommandRegistry;
    /**
     * The document registry
     */
    docRegistry: DocumentRegistry;
    /**
     * Group of Pull Requests
     */
    group: IPullRequestGroup;
}
/**
 * BrowserGroup component
 *
 * @param props Component properties
 */
export declare function BrowserGroup(props: IBrowserGroupProps): JSX.Element;
