/// <reference types="react" />
import { ReactWidget } from '@jupyterlab/apputils';
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { CommandRegistry } from '@lumino/commands';
import { Message } from '@lumino/messaging';
/**
 * React wrapper to mount and umount the React child component
 * when the widget is shown/hidden.
 *
 * In this case this is particularly interesting to trigger the
 * useEffect of the React widget to update the pull requests list
 * each time the user come back to the panel.
 */
export declare class PullRequestPanelWrapper extends ReactWidget {
    constructor(commands: CommandRegistry, docRegistry: DocumentRegistry);
    onBeforeShow(msg: Message): void;
    onBeforeHide(msg: Message): void;
    render(): JSX.Element;
    private _commands;
    private _docRegistry;
}
/**
 * PullRequestPanel properties
 */
export interface IPullRequestPanelProps {
    /**
     * Jupyter Front End Commands Registry
     */
    commands: CommandRegistry;
    /**
     * Document registry
     */
    docRegistry: DocumentRegistry;
}
/**
 * PullRequestPanel component
 *
 * @param props PullRequestPanel properties
 */
export declare function PullRequestPanel(props: IPullRequestPanelProps): JSX.Element;
