"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const __1 = require("..");
const util_1 = require("./util");
test('file paths are relative to the project outdir', () => {
    // GIVEN
    const p = new util_1.TestProject();
    // WHEN
    const f = new __1.TextFile(p, 'foo/bar.txt');
    // THEN
    expect(f.absolutePath).toBe(path.resolve(p.outdir, f.path));
    expect(path.isAbsolute(f.absolutePath)).toBeTruthy();
});
test('all files added to the project can be enumerated', () => {
    // GIVEN
    const p = new util_1.TestProject();
    new __1.TextFile(p, 'my.txt');
    new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result = p.files;
    // THEN
    const exp = (e) => expect(result.map(x => x.path).includes(e)).toBeTruthy();
    exp('my.txt');
    exp('your/file/me.json');
});
test('findFile() can be used to find a file either absolute or relative path', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const file = new __1.JsonFile(p, 'your/file/me.json', { obj: {} });
    // WHEN
    const result1 = p.tryFindFile('your/file/me.json');
    const result2 = p.tryFindFile(path.resolve(p.outdir, 'your/file/me.json'));
    // THEN
    expect(result1 === file).toBeTruthy();
    expect(result2 === file).toBeTruthy();
});
test('findFile() will also look up files in subprojects', () => {
    // GIVEN
    const p = new util_1.TestProject();
    const child = new __1.Project({ name: 'foobar', parent: p, outdir: 'subproject/foo/bar' });
    const fchild = new __1.TextFile(child, 'fchild.txt');
    // WHEN
    const result1 = p.tryFindFile('subproject/foo/bar/fchild.txt');
    const result2 = child.tryFindFile('fchild.txt');
    // THEN
    expect(result1 === fchild).toBeTruthy();
    expect(result2 === fchild).toBeTruthy();
});
//# sourceMappingURL=data:application/json;base64,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