import * as pr from 'projen';
export interface AutomationProps {
    /**
     * The github token for automation
     *
     * @default - GITHUB_TOKEN
     */
    readonly automationToken?: string;
}
interface projenYarnUpgradeOptions {
    /**
     * run `yarn test`
     * @default false
     */
    readonly yarnTest?: boolean;
}
export declare class Automation {
    readonly project: pr.Project;
    readonly automationToken: string;
    constructor(project: pr.Project, props?: AutomationProps);
    autoMerge(): void;
    autoApprove(): void;
    projenYarnUpgrade(id?: string, opts?: projenYarnUpgradeOptions): void;
}
export {};
